package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EtcdSpecBuilder extends EtcdSpecFluentImpl<EtcdSpecBuilder> implements VisitableBuilder<EtcdSpec,EtcdSpecBuilder>{
  public EtcdSpecBuilder() {
    this(false);
  }
  public EtcdSpecBuilder(Boolean validationEnabled) {
    this(new EtcdSpec(), validationEnabled);
  }
  public EtcdSpecBuilder(EtcdSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public EtcdSpecBuilder(EtcdSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EtcdSpec(), validationEnabled);
  }
  public EtcdSpecBuilder(EtcdSpecFluent<?> fluent,EtcdSpec instance) {
    this(fluent, instance, false);
  }
  public EtcdSpecBuilder(EtcdSpecFluent<?> fluent,EtcdSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withFailedRevisionLimit(instance.getFailedRevisionLimit()); 
    fluent.withForceRedeploymentReason(instance.getForceRedeploymentReason()); 
    fluent.withLogLevel(instance.getLogLevel()); 
    fluent.withManagementState(instance.getManagementState()); 
    fluent.withObservedConfig(instance.getObservedConfig()); 
    fluent.withOperatorLogLevel(instance.getOperatorLogLevel()); 
    fluent.withSucceededRevisionLimit(instance.getSucceededRevisionLimit()); 
    fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public EtcdSpecBuilder(EtcdSpec instance) {
    this(instance,false);
  }
  public EtcdSpecBuilder(EtcdSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withFailedRevisionLimit(instance.getFailedRevisionLimit()); 
    this.withForceRedeploymentReason(instance.getForceRedeploymentReason()); 
    this.withLogLevel(instance.getLogLevel()); 
    this.withManagementState(instance.getManagementState()); 
    this.withObservedConfig(instance.getObservedConfig()); 
    this.withOperatorLogLevel(instance.getOperatorLogLevel()); 
    this.withSucceededRevisionLimit(instance.getSucceededRevisionLimit()); 
    this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  EtcdSpecFluent<?> fluent;
  Boolean validationEnabled;
  public EtcdSpec build() {
    EtcdSpec buildable = new EtcdSpec(fluent.getFailedRevisionLimit(),fluent.getForceRedeploymentReason(),fluent.getLogLevel(),fluent.getManagementState(),fluent.getObservedConfig(),fluent.getOperatorLogLevel(),fluent.getSucceededRevisionLimit(),fluent.getUnsupportedConfigOverrides());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}