package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EtcdListBuilder extends EtcdListFluentImpl<EtcdListBuilder> implements VisitableBuilder<EtcdList,EtcdListBuilder>{
  public EtcdListBuilder() {
    this(false);
  }
  public EtcdListBuilder(Boolean validationEnabled) {
    this(new EtcdList(), validationEnabled);
  }
  public EtcdListBuilder(EtcdListFluent<?> fluent) {
    this(fluent, false);
  }
  public EtcdListBuilder(EtcdListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EtcdList(), validationEnabled);
  }
  public EtcdListBuilder(EtcdListFluent<?> fluent,EtcdList instance) {
    this(fluent, instance, false);
  }
  public EtcdListBuilder(EtcdListFluent<?> fluent,EtcdList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public EtcdListBuilder(EtcdList instance) {
    this(instance,false);
  }
  public EtcdListBuilder(EtcdList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  EtcdListFluent<?> fluent;
  Boolean validationEnabled;
  public EtcdList build() {
    EtcdList buildable = new EtcdList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}