package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.openshift.api.model.config.v1.DNSZone;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class DNSZoneStatusFluentImpl<A extends DNSZoneStatusFluent<A>> extends BaseFluent<A> implements DNSZoneStatusFluent<A>{
  public DNSZoneStatusFluentImpl() {
  }
  public DNSZoneStatusFluentImpl(DNSZoneStatus instance) {
    this.withConditions(instance.getConditions()); 
    this.withDnsZone(instance.getDnsZone()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<DNSZoneConditionBuilder> conditions = new ArrayList<DNSZoneConditionBuilder>();
  private DNSZone dnsZone;
  private Map<String,Object> additionalProperties;
  public A addToConditions(Integer index,DNSZoneCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<DNSZoneConditionBuilder>();}
    DNSZoneConditionBuilder builder = new DNSZoneConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(Integer index,DNSZoneCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<DNSZoneConditionBuilder>();}
    DNSZoneConditionBuilder builder = new DNSZoneConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.openshift.api.model.operator.v1.DNSZoneCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<DNSZoneConditionBuilder>();}
    for (DNSZoneCondition item : items) {DNSZoneConditionBuilder builder = new DNSZoneConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<DNSZoneCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<DNSZoneConditionBuilder>();}
    for (DNSZoneCondition item : items) {DNSZoneConditionBuilder builder = new DNSZoneConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.openshift.api.model.operator.v1.DNSZoneCondition... items) {
    for (DNSZoneCondition item : items) {DNSZoneConditionBuilder builder = new DNSZoneConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<DNSZoneCondition> items) {
    for (DNSZoneCondition item : items) {DNSZoneConditionBuilder builder = new DNSZoneConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<DNSZoneConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<DNSZoneConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      DNSZoneConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<DNSZoneCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<DNSZoneCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public DNSZoneCondition buildCondition(Integer index) {
    return this.conditions.get(index).build();
  }
  public DNSZoneCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public DNSZoneCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public DNSZoneCondition buildMatchingCondition(Predicate<DNSZoneConditionBuilder> predicate) {
    for (DNSZoneConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<DNSZoneConditionBuilder> predicate) {
    for (DNSZoneConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<DNSZoneCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new ArrayList(); for (DNSZoneCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.openshift.api.model.operator.v1.DNSZoneCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (DNSZoneCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)addToConditions(new DNSZoneCondition(lastTransitionTime, message, reason, status, type));
  }
  public DNSZoneStatusFluent.ConditionsNested<A> addNewCondition() {
    return new DNSZoneStatusFluentImpl.ConditionsNestedImpl();
  }
  public DNSZoneStatusFluent.ConditionsNested<A> addNewConditionLike(DNSZoneCondition item) {
    return new DNSZoneStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public DNSZoneStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index,DNSZoneCondition item) {
    return new DNSZoneStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public DNSZoneStatusFluent.ConditionsNested<A> editCondition(Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public DNSZoneStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public DNSZoneStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public DNSZoneStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<DNSZoneConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public DNSZone getDnsZone() {
    return this.dnsZone;
  }
  public A withDnsZone(DNSZone dnsZone) {
    this.dnsZone=dnsZone; return (A) this;
  }
  public Boolean hasDnsZone() {
    return this.dnsZone != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DNSZoneStatusFluentImpl that = (DNSZoneStatusFluentImpl) o;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (dnsZone != null ? !dnsZone.equals(that.dnsZone) :that.dnsZone != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  dnsZone,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (dnsZone != null) { sb.append("dnsZone:"); sb.append(dnsZone + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends DNSZoneConditionFluentImpl<DNSZoneStatusFluent.ConditionsNested<N>> implements DNSZoneStatusFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(Integer index,DNSZoneCondition item) {
      this.index = index;
      this.builder = new DNSZoneConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new DNSZoneConditionBuilder(this);
    }
    DNSZoneConditionBuilder builder;
    Integer index;
    public N and() {
      return (N) DNSZoneStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  
}