package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OVNKubernetesConfigBuilder extends OVNKubernetesConfigFluentImpl<OVNKubernetesConfigBuilder> implements VisitableBuilder<OVNKubernetesConfig,OVNKubernetesConfigBuilder>{
  public OVNKubernetesConfigBuilder() {
    this(false);
  }
  public OVNKubernetesConfigBuilder(Boolean validationEnabled) {
    this(new OVNKubernetesConfig(), validationEnabled);
  }
  public OVNKubernetesConfigBuilder(OVNKubernetesConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public OVNKubernetesConfigBuilder(OVNKubernetesConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OVNKubernetesConfig(), validationEnabled);
  }
  public OVNKubernetesConfigBuilder(OVNKubernetesConfigFluent<?> fluent,OVNKubernetesConfig instance) {
    this(fluent, instance, false);
  }
  public OVNKubernetesConfigBuilder(OVNKubernetesConfigFluent<?> fluent,OVNKubernetesConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withGenevePort(instance.getGenevePort()); 
    fluent.withHybridOverlayConfig(instance.getHybridOverlayConfig()); 
    fluent.withIpsecConfig(instance.getIpsecConfig()); 
    fluent.withMtu(instance.getMtu()); 
    fluent.withPolicyAuditConfig(instance.getPolicyAuditConfig()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OVNKubernetesConfigBuilder(OVNKubernetesConfig instance) {
    this(instance,false);
  }
  public OVNKubernetesConfigBuilder(OVNKubernetesConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withGenevePort(instance.getGenevePort()); 
    this.withHybridOverlayConfig(instance.getHybridOverlayConfig()); 
    this.withIpsecConfig(instance.getIpsecConfig()); 
    this.withMtu(instance.getMtu()); 
    this.withPolicyAuditConfig(instance.getPolicyAuditConfig()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  OVNKubernetesConfigFluent<?> fluent;
  Boolean validationEnabled;
  public OVNKubernetesConfig build() {
    OVNKubernetesConfig buildable = new OVNKubernetesConfig(fluent.getGenevePort(),fluent.getHybridOverlayConfig(),fluent.getIpsecConfig(),fluent.getMtu(),fluent.getPolicyAuditConfig());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}