package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IPAMConfigBuilder extends IPAMConfigFluentImpl<IPAMConfigBuilder> implements VisitableBuilder<IPAMConfig,IPAMConfigBuilder>{
  public IPAMConfigBuilder() {
    this(false);
  }
  public IPAMConfigBuilder(Boolean validationEnabled) {
    this(new IPAMConfig(), validationEnabled);
  }
  public IPAMConfigBuilder(IPAMConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public IPAMConfigBuilder(IPAMConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IPAMConfig(), validationEnabled);
  }
  public IPAMConfigBuilder(IPAMConfigFluent<?> fluent,IPAMConfig instance) {
    this(fluent, instance, false);
  }
  public IPAMConfigBuilder(IPAMConfigFluent<?> fluent,IPAMConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withStaticIPAMConfig(instance.getStaticIPAMConfig()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public IPAMConfigBuilder(IPAMConfig instance) {
    this(instance,false);
  }
  public IPAMConfigBuilder(IPAMConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withStaticIPAMConfig(instance.getStaticIPAMConfig()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  IPAMConfigFluent<?> fluent;
  Boolean validationEnabled;
  public IPAMConfig build() {
    IPAMConfig buildable = new IPAMConfig(fluent.getStaticIPAMConfig(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}