package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AddPageBuilder extends AddPageFluentImpl<AddPageBuilder> implements VisitableBuilder<AddPage,AddPageBuilder>{
  public AddPageBuilder() {
    this(false);
  }
  public AddPageBuilder(Boolean validationEnabled) {
    this(new AddPage(), validationEnabled);
  }
  public AddPageBuilder(AddPageFluent<?> fluent) {
    this(fluent, false);
  }
  public AddPageBuilder(AddPageFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AddPage(), validationEnabled);
  }
  public AddPageBuilder(AddPageFluent<?> fluent,AddPage instance) {
    this(fluent, instance, false);
  }
  public AddPageBuilder(AddPageFluent<?> fluent,AddPage instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDisabledActions(instance.getDisabledActions()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public AddPageBuilder(AddPage instance) {
    this(instance,false);
  }
  public AddPageBuilder(AddPage instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withDisabledActions(instance.getDisabledActions()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  AddPageFluent<?> fluent;
  Boolean validationEnabled;
  public AddPage build() {
    AddPage buildable = new AddPage(fluent.getDisabledActions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}