package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ForwardPluginBuilder extends ForwardPluginFluent<ForwardPluginBuilder> implements VisitableBuilder<ForwardPlugin,ForwardPluginBuilder>{
  public ForwardPluginBuilder() {
    this(new ForwardPlugin());
  }
  
  public ForwardPluginBuilder(ForwardPluginFluent<?> fluent) {
    this(fluent, new ForwardPlugin());
  }
  
  public ForwardPluginBuilder(ForwardPluginFluent<?> fluent,ForwardPlugin instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ForwardPluginBuilder(ForwardPlugin instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ForwardPluginFluent<?> fluent;
  
  public ForwardPlugin build() {
    ForwardPlugin buildable = new ForwardPlugin(fluent.getPolicy(),fluent.getProtocolStrategy(),fluent.buildTransportConfig(),fluent.getUpstreams());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}