package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClusterCSIDriverStatusBuilder extends ClusterCSIDriverStatusFluent<ClusterCSIDriverStatusBuilder> implements VisitableBuilder<ClusterCSIDriverStatus,ClusterCSIDriverStatusBuilder>{
  public ClusterCSIDriverStatusBuilder() {
    this(new ClusterCSIDriverStatus());
  }
  
  public ClusterCSIDriverStatusBuilder(ClusterCSIDriverStatusFluent<?> fluent) {
    this(fluent, new ClusterCSIDriverStatus());
  }
  
  public ClusterCSIDriverStatusBuilder(ClusterCSIDriverStatusFluent<?> fluent,ClusterCSIDriverStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClusterCSIDriverStatusBuilder(ClusterCSIDriverStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClusterCSIDriverStatusFluent<?> fluent;
  
  public ClusterCSIDriverStatus build() {
    ClusterCSIDriverStatus buildable = new ClusterCSIDriverStatus(fluent.buildConditions(),fluent.buildGenerations(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}