package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AzureCSIDriverConfigSpecBuilder extends AzureCSIDriverConfigSpecFluent<AzureCSIDriverConfigSpecBuilder> implements VisitableBuilder<AzureCSIDriverConfigSpec,AzureCSIDriverConfigSpecBuilder>{
  public AzureCSIDriverConfigSpecBuilder() {
    this(new AzureCSIDriverConfigSpec());
  }
  
  public AzureCSIDriverConfigSpecBuilder(AzureCSIDriverConfigSpecFluent<?> fluent) {
    this(fluent, new AzureCSIDriverConfigSpec());
  }
  
  public AzureCSIDriverConfigSpecBuilder(AzureCSIDriverConfigSpecFluent<?> fluent,AzureCSIDriverConfigSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AzureCSIDriverConfigSpecBuilder(AzureCSIDriverConfigSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AzureCSIDriverConfigSpecFluent<?> fluent;
  
  public AzureCSIDriverConfigSpec build() {
    AzureCSIDriverConfigSpec buildable = new AzureCSIDriverConfigSpec(fluent.buildDiskEncryptionSet());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}