package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PolicyAuditConfigBuilder extends PolicyAuditConfigFluent<PolicyAuditConfigBuilder> implements VisitableBuilder<PolicyAuditConfig,PolicyAuditConfigBuilder>{
  public PolicyAuditConfigBuilder() {
    this(new PolicyAuditConfig());
  }
  
  public PolicyAuditConfigBuilder(PolicyAuditConfigFluent<?> fluent) {
    this(fluent, new PolicyAuditConfig());
  }
  
  public PolicyAuditConfigBuilder(PolicyAuditConfigFluent<?> fluent,PolicyAuditConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PolicyAuditConfigBuilder(PolicyAuditConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PolicyAuditConfigFluent<?> fluent;
  
  public PolicyAuditConfig build() {
    PolicyAuditConfig buildable = new PolicyAuditConfig(fluent.getDestination(),fluent.getMaxFileSize(),fluent.getMaxLogFiles(),fluent.getRateLimit(),fluent.getSyslogFacility());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}