package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class OpenShiftAPIServerListBuilder extends OpenShiftAPIServerListFluent<OpenShiftAPIServerListBuilder> implements VisitableBuilder<OpenShiftAPIServerList,OpenShiftAPIServerListBuilder>{
  public OpenShiftAPIServerListBuilder() {
    this(new OpenShiftAPIServerList());
  }
  
  public OpenShiftAPIServerListBuilder(OpenShiftAPIServerListFluent<?> fluent) {
    this(fluent, new OpenShiftAPIServerList());
  }
  
  public OpenShiftAPIServerListBuilder(OpenShiftAPIServerListFluent<?> fluent,OpenShiftAPIServerList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public OpenShiftAPIServerListBuilder(OpenShiftAPIServerList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  OpenShiftAPIServerListFluent<?> fluent;
  
  public OpenShiftAPIServerList build() {
    OpenShiftAPIServerList buildable = new OpenShiftAPIServerList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}