package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KubeSchedulerSpecBuilder extends KubeSchedulerSpecFluent<KubeSchedulerSpecBuilder> implements VisitableBuilder<KubeSchedulerSpec,KubeSchedulerSpecBuilder>{
  public KubeSchedulerSpecBuilder() {
    this(new KubeSchedulerSpec());
  }
  
  public KubeSchedulerSpecBuilder(KubeSchedulerSpecFluent<?> fluent) {
    this(fluent, new KubeSchedulerSpec());
  }
  
  public KubeSchedulerSpecBuilder(KubeSchedulerSpecFluent<?> fluent,KubeSchedulerSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KubeSchedulerSpecBuilder(KubeSchedulerSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KubeSchedulerSpecFluent<?> fluent;
  
  public KubeSchedulerSpec build() {
    KubeSchedulerSpec buildable = new KubeSchedulerSpec(fluent.getFailedRevisionLimit(),fluent.getForceRedeploymentReason(),fluent.getLogLevel(),fluent.getManagementState(),fluent.buildObservedConfig(),fluent.getOperatorLogLevel(),fluent.getSucceededRevisionLimit(),fluent.buildUnsupportedConfigOverrides());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}