package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class EtcdSpecBuilder extends EtcdSpecFluent<EtcdSpecBuilder> implements VisitableBuilder<EtcdSpec,EtcdSpecBuilder>{
  public EtcdSpecBuilder() {
    this(new EtcdSpec());
  }
  
  public EtcdSpecBuilder(EtcdSpecFluent<?> fluent) {
    this(fluent, new EtcdSpec());
  }
  
  public EtcdSpecBuilder(EtcdSpecFluent<?> fluent,EtcdSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public EtcdSpecBuilder(EtcdSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  EtcdSpecFluent<?> fluent;
  
  public EtcdSpec build() {
    EtcdSpec buildable = new EtcdSpec(fluent.getFailedRevisionLimit(),fluent.getForceRedeploymentReason(),fluent.getLogLevel(),fluent.getManagementState(),fluent.buildObservedConfig(),fluent.getOperatorLogLevel(),fluent.getSucceededRevisionLimit(),fluent.buildUnsupportedConfigOverrides());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}