package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class EtcdBuilder extends EtcdFluent<EtcdBuilder> implements VisitableBuilder<Etcd,EtcdBuilder>{
  public EtcdBuilder() {
    this(new Etcd());
  }
  
  public EtcdBuilder(EtcdFluent<?> fluent) {
    this(fluent, new Etcd());
  }
  
  public EtcdBuilder(EtcdFluent<?> fluent,Etcd instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public EtcdBuilder(Etcd instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  EtcdFluent<?> fluent;
  
  public Etcd build() {
    Etcd buildable = new Etcd(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}