package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ConfigSpecBuilder extends ConfigSpecFluent<ConfigSpecBuilder> implements VisitableBuilder<ConfigSpec,ConfigSpecBuilder>{
  public ConfigSpecBuilder() {
    this(new ConfigSpec());
  }
  
  public ConfigSpecBuilder(ConfigSpecFluent<?> fluent) {
    this(fluent, new ConfigSpec());
  }
  
  public ConfigSpecBuilder(ConfigSpecFluent<?> fluent,ConfigSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ConfigSpecBuilder(ConfigSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ConfigSpecFluent<?> fluent;
  
  public ConfigSpec build() {
    ConfigSpec buildable = new ConfigSpec(fluent.getLogLevel(),fluent.getManagementState(),fluent.buildObservedConfig(),fluent.getOperatorLogLevel(),fluent.buildUnsupportedConfigOverrides());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}