package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class CloudCredentialSpecBuilder extends CloudCredentialSpecFluent<CloudCredentialSpecBuilder> implements VisitableBuilder<CloudCredentialSpec,CloudCredentialSpecBuilder>{
  public CloudCredentialSpecBuilder() {
    this(new CloudCredentialSpec());
  }
  
  public CloudCredentialSpecBuilder(CloudCredentialSpecFluent<?> fluent) {
    this(fluent, new CloudCredentialSpec());
  }
  
  public CloudCredentialSpecBuilder(CloudCredentialSpecFluent<?> fluent,CloudCredentialSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public CloudCredentialSpecBuilder(CloudCredentialSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  CloudCredentialSpecFluent<?> fluent;
  
  public CloudCredentialSpec build() {
    CloudCredentialSpec buildable = new CloudCredentialSpec(fluent.getCredentialsMode(),fluent.getLogLevel(),fluent.getManagementState(),fluent.buildObservedConfig(),fluent.getOperatorLogLevel(),fluent.buildUnsupportedConfigOverrides());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}