/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.openshift.api.model.operator.v1.AccessLogging;
import io.fabric8.openshift.api.model.operator.v1.AccessLoggingFluent;
import io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookie;
import io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookieBuilder;
import io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookieFluentImpl;
import io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPHeaders;
import io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPHeadersBuilder;
import io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPHeadersFluentImpl;
import io.fabric8.openshift.api.model.operator.v1.LoggingDestination;
import io.fabric8.openshift.api.model.operator.v1.LoggingDestinationBuilder;
import io.fabric8.openshift.api.model.operator.v1.LoggingDestinationFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class AccessLoggingFluentImpl<A extends AccessLoggingFluent<A>>
extends BaseFluent<A>
implements AccessLoggingFluent<A> {
    private LoggingDestinationBuilder destination;
    private List<IngressControllerCaptureHTTPCookieBuilder> httpCaptureCookies = new ArrayList<IngressControllerCaptureHTTPCookieBuilder>();
    private IngressControllerCaptureHTTPHeadersBuilder httpCaptureHeaders;
    private String httpLogFormat;

    public AccessLoggingFluentImpl() {
    }

    public AccessLoggingFluentImpl(AccessLogging instance) {
        this.withDestination(instance.getDestination());
        this.withHttpCaptureCookies(instance.getHttpCaptureCookies());
        this.withHttpCaptureHeaders(instance.getHttpCaptureHeaders());
        this.withHttpLogFormat(instance.getHttpLogFormat());
    }

    @Override
    @Deprecated
    public LoggingDestination getDestination() {
        return this.destination != null ? this.destination.build() : null;
    }

    @Override
    public LoggingDestination buildDestination() {
        return this.destination != null ? this.destination.build() : null;
    }

    @Override
    public A withDestination(LoggingDestination destination) {
        this._visitables.get((Object)"destination").remove(this.destination);
        if (destination != null) {
            this.destination = new LoggingDestinationBuilder(destination);
            this._visitables.get((Object)"destination").add(this.destination);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDestination() {
        return this.destination != null;
    }

    @Override
    public AccessLoggingFluent.DestinationNested<A> withNewDestination() {
        return new DestinationNestedImpl();
    }

    @Override
    public AccessLoggingFluent.DestinationNested<A> withNewDestinationLike(LoggingDestination item) {
        return new DestinationNestedImpl(item);
    }

    @Override
    public AccessLoggingFluent.DestinationNested<A> editDestination() {
        return this.withNewDestinationLike(this.getDestination());
    }

    @Override
    public AccessLoggingFluent.DestinationNested<A> editOrNewDestination() {
        return this.withNewDestinationLike(this.getDestination() != null ? this.getDestination() : new LoggingDestinationBuilder().build());
    }

    @Override
    public AccessLoggingFluent.DestinationNested<A> editOrNewDestinationLike(LoggingDestination item) {
        return this.withNewDestinationLike(this.getDestination() != null ? this.getDestination() : item);
    }

    @Override
    public A addToHttpCaptureCookies(int index, IngressControllerCaptureHTTPCookie item) {
        if (this.httpCaptureCookies == null) {
            this.httpCaptureCookies = new ArrayList<IngressControllerCaptureHTTPCookieBuilder>();
        }
        IngressControllerCaptureHTTPCookieBuilder builder = new IngressControllerCaptureHTTPCookieBuilder(item);
        this._visitables.get((Object)"httpCaptureCookies").add(index >= 0 ? index : this._visitables.get((Object)"httpCaptureCookies").size(), builder);
        this.httpCaptureCookies.add(index >= 0 ? index : this.httpCaptureCookies.size(), builder);
        return (A)this;
    }

    @Override
    public A setToHttpCaptureCookies(int index, IngressControllerCaptureHTTPCookie item) {
        if (this.httpCaptureCookies == null) {
            this.httpCaptureCookies = new ArrayList<IngressControllerCaptureHTTPCookieBuilder>();
        }
        IngressControllerCaptureHTTPCookieBuilder builder = new IngressControllerCaptureHTTPCookieBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"httpCaptureCookies").size()) {
            this._visitables.get((Object)"httpCaptureCookies").add(builder);
        } else {
            this._visitables.get((Object)"httpCaptureCookies").set(index, builder);
        }
        if (index < 0 || index >= this.httpCaptureCookies.size()) {
            this.httpCaptureCookies.add(builder);
        } else {
            this.httpCaptureCookies.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToHttpCaptureCookies(IngressControllerCaptureHTTPCookie ... items) {
        if (this.httpCaptureCookies == null) {
            this.httpCaptureCookies = new ArrayList<IngressControllerCaptureHTTPCookieBuilder>();
        }
        for (IngressControllerCaptureHTTPCookie item : items) {
            IngressControllerCaptureHTTPCookieBuilder builder = new IngressControllerCaptureHTTPCookieBuilder(item);
            this._visitables.get((Object)"httpCaptureCookies").add(builder);
            this.httpCaptureCookies.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToHttpCaptureCookies(Collection<IngressControllerCaptureHTTPCookie> items) {
        if (this.httpCaptureCookies == null) {
            this.httpCaptureCookies = new ArrayList<IngressControllerCaptureHTTPCookieBuilder>();
        }
        for (IngressControllerCaptureHTTPCookie item : items) {
            IngressControllerCaptureHTTPCookieBuilder builder = new IngressControllerCaptureHTTPCookieBuilder(item);
            this._visitables.get((Object)"httpCaptureCookies").add(builder);
            this.httpCaptureCookies.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromHttpCaptureCookies(IngressControllerCaptureHTTPCookie ... items) {
        for (IngressControllerCaptureHTTPCookie item : items) {
            IngressControllerCaptureHTTPCookieBuilder builder = new IngressControllerCaptureHTTPCookieBuilder(item);
            this._visitables.get((Object)"httpCaptureCookies").remove(builder);
            if (this.httpCaptureCookies == null) continue;
            this.httpCaptureCookies.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHttpCaptureCookies(Collection<IngressControllerCaptureHTTPCookie> items) {
        for (IngressControllerCaptureHTTPCookie item : items) {
            IngressControllerCaptureHTTPCookieBuilder builder = new IngressControllerCaptureHTTPCookieBuilder(item);
            this._visitables.get((Object)"httpCaptureCookies").remove(builder);
            if (this.httpCaptureCookies == null) continue;
            this.httpCaptureCookies.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromHttpCaptureCookies(Predicate<IngressControllerCaptureHTTPCookieBuilder> predicate) {
        if (this.httpCaptureCookies == null) {
            return (A)this;
        }
        Iterator<IngressControllerCaptureHTTPCookieBuilder> each = this.httpCaptureCookies.iterator();
        List visitables = this._visitables.get((Object)"httpCaptureCookies");
        while (each.hasNext()) {
            IngressControllerCaptureHTTPCookieBuilder builder = each.next();
            if (!predicate.apply((Object)builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<IngressControllerCaptureHTTPCookie> getHttpCaptureCookies() {
        return AccessLoggingFluentImpl.build(this.httpCaptureCookies);
    }

    @Override
    public List<IngressControllerCaptureHTTPCookie> buildHttpCaptureCookies() {
        return AccessLoggingFluentImpl.build(this.httpCaptureCookies);
    }

    @Override
    public IngressControllerCaptureHTTPCookie buildHttpCaptureCooky(int index) {
        return this.httpCaptureCookies.get(index).build();
    }

    @Override
    public IngressControllerCaptureHTTPCookie buildFirstHttpCaptureCooky() {
        return this.httpCaptureCookies.get(0).build();
    }

    @Override
    public IngressControllerCaptureHTTPCookie buildLastHttpCaptureCooky() {
        return this.httpCaptureCookies.get(this.httpCaptureCookies.size() - 1).build();
    }

    @Override
    public IngressControllerCaptureHTTPCookie buildMatchingHttpCaptureCooky(Predicate<IngressControllerCaptureHTTPCookieBuilder> predicate) {
        for (IngressControllerCaptureHTTPCookieBuilder item : this.httpCaptureCookies) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingHttpCaptureCooky(Predicate<IngressControllerCaptureHTTPCookieBuilder> predicate) {
        for (IngressControllerCaptureHTTPCookieBuilder item : this.httpCaptureCookies) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withHttpCaptureCookies(List<IngressControllerCaptureHTTPCookie> httpCaptureCookies) {
        if (this.httpCaptureCookies != null) {
            this._visitables.get((Object)"httpCaptureCookies").removeAll(this.httpCaptureCookies);
        }
        if (httpCaptureCookies != null) {
            this.httpCaptureCookies = new ArrayList<IngressControllerCaptureHTTPCookieBuilder>();
            for (IngressControllerCaptureHTTPCookie item : httpCaptureCookies) {
                this.addToHttpCaptureCookies(item);
            }
        } else {
            this.httpCaptureCookies = null;
        }
        return (A)this;
    }

    @Override
    public A withHttpCaptureCookies(IngressControllerCaptureHTTPCookie ... httpCaptureCookies) {
        if (this.httpCaptureCookies != null) {
            this.httpCaptureCookies.clear();
        }
        if (httpCaptureCookies != null) {
            for (IngressControllerCaptureHTTPCookie item : httpCaptureCookies) {
                this.addToHttpCaptureCookies(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHttpCaptureCookies() {
        return this.httpCaptureCookies != null && !this.httpCaptureCookies.isEmpty();
    }

    @Override
    public A addNewHttpCaptureCooky(String matchType, Integer maxLength, String name, String namePrefix) {
        return this.addToHttpCaptureCookies(new IngressControllerCaptureHTTPCookie(matchType, maxLength, name, namePrefix));
    }

    @Override
    public AccessLoggingFluent.HttpCaptureCookiesNested<A> addNewHttpCaptureCooky() {
        return new HttpCaptureCookiesNestedImpl();
    }

    @Override
    public AccessLoggingFluent.HttpCaptureCookiesNested<A> addNewHttpCaptureCookyLike(IngressControllerCaptureHTTPCookie item) {
        return new HttpCaptureCookiesNestedImpl(-1, item);
    }

    @Override
    public AccessLoggingFluent.HttpCaptureCookiesNested<A> setNewHttpCaptureCookyLike(int index, IngressControllerCaptureHTTPCookie item) {
        return new HttpCaptureCookiesNestedImpl(index, item);
    }

    @Override
    public AccessLoggingFluent.HttpCaptureCookiesNested<A> editHttpCaptureCooky(int index) {
        if (this.httpCaptureCookies.size() <= index) {
            throw new RuntimeException("Can't edit httpCaptureCookies. Index exceeds size.");
        }
        return this.setNewHttpCaptureCookyLike(index, this.buildHttpCaptureCooky(index));
    }

    @Override
    public AccessLoggingFluent.HttpCaptureCookiesNested<A> editFirstHttpCaptureCooky() {
        if (this.httpCaptureCookies.size() == 0) {
            throw new RuntimeException("Can't edit first httpCaptureCookies. The list is empty.");
        }
        return this.setNewHttpCaptureCookyLike(0, this.buildHttpCaptureCooky(0));
    }

    @Override
    public AccessLoggingFluent.HttpCaptureCookiesNested<A> editLastHttpCaptureCooky() {
        int index = this.httpCaptureCookies.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last httpCaptureCookies. The list is empty.");
        }
        return this.setNewHttpCaptureCookyLike(index, this.buildHttpCaptureCooky(index));
    }

    @Override
    public AccessLoggingFluent.HttpCaptureCookiesNested<A> editMatchingHttpCaptureCooky(Predicate<IngressControllerCaptureHTTPCookieBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.httpCaptureCookies.size(); ++i) {
            if (!predicate.apply((Object)this.httpCaptureCookies.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching httpCaptureCookies. No match found.");
        }
        return this.setNewHttpCaptureCookyLike(index, this.buildHttpCaptureCooky(index));
    }

    @Override
    @Deprecated
    public IngressControllerCaptureHTTPHeaders getHttpCaptureHeaders() {
        return this.httpCaptureHeaders != null ? this.httpCaptureHeaders.build() : null;
    }

    @Override
    public IngressControllerCaptureHTTPHeaders buildHttpCaptureHeaders() {
        return this.httpCaptureHeaders != null ? this.httpCaptureHeaders.build() : null;
    }

    @Override
    public A withHttpCaptureHeaders(IngressControllerCaptureHTTPHeaders httpCaptureHeaders) {
        this._visitables.get((Object)"httpCaptureHeaders").remove(this.httpCaptureHeaders);
        if (httpCaptureHeaders != null) {
            this.httpCaptureHeaders = new IngressControllerCaptureHTTPHeadersBuilder(httpCaptureHeaders);
            this._visitables.get((Object)"httpCaptureHeaders").add(this.httpCaptureHeaders);
        }
        return (A)this;
    }

    @Override
    public Boolean hasHttpCaptureHeaders() {
        return this.httpCaptureHeaders != null;
    }

    @Override
    public AccessLoggingFluent.HttpCaptureHeadersNested<A> withNewHttpCaptureHeaders() {
        return new HttpCaptureHeadersNestedImpl();
    }

    @Override
    public AccessLoggingFluent.HttpCaptureHeadersNested<A> withNewHttpCaptureHeadersLike(IngressControllerCaptureHTTPHeaders item) {
        return new HttpCaptureHeadersNestedImpl(item);
    }

    @Override
    public AccessLoggingFluent.HttpCaptureHeadersNested<A> editHttpCaptureHeaders() {
        return this.withNewHttpCaptureHeadersLike(this.getHttpCaptureHeaders());
    }

    @Override
    public AccessLoggingFluent.HttpCaptureHeadersNested<A> editOrNewHttpCaptureHeaders() {
        return this.withNewHttpCaptureHeadersLike(this.getHttpCaptureHeaders() != null ? this.getHttpCaptureHeaders() : new IngressControllerCaptureHTTPHeadersBuilder().build());
    }

    @Override
    public AccessLoggingFluent.HttpCaptureHeadersNested<A> editOrNewHttpCaptureHeadersLike(IngressControllerCaptureHTTPHeaders item) {
        return this.withNewHttpCaptureHeadersLike(this.getHttpCaptureHeaders() != null ? this.getHttpCaptureHeaders() : item);
    }

    @Override
    public String getHttpLogFormat() {
        return this.httpLogFormat;
    }

    @Override
    public A withHttpLogFormat(String httpLogFormat) {
        this.httpLogFormat = httpLogFormat;
        return (A)this;
    }

    @Override
    public Boolean hasHttpLogFormat() {
        return this.httpLogFormat != null;
    }

    @Override
    public A withNewHttpLogFormat(String arg1) {
        return this.withHttpLogFormat(new String(arg1));
    }

    @Override
    public A withNewHttpLogFormat(StringBuilder arg1) {
        return this.withHttpLogFormat(new String(arg1));
    }

    @Override
    public A withNewHttpLogFormat(StringBuffer arg1) {
        return this.withHttpLogFormat(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessLoggingFluentImpl that = (AccessLoggingFluentImpl)o;
        if (this.destination != null ? !this.destination.equals(that.destination) : that.destination != null) {
            return false;
        }
        if (this.httpCaptureCookies != null ? !this.httpCaptureCookies.equals(that.httpCaptureCookies) : that.httpCaptureCookies != null) {
            return false;
        }
        if (this.httpCaptureHeaders != null ? !this.httpCaptureHeaders.equals(that.httpCaptureHeaders) : that.httpCaptureHeaders != null) {
            return false;
        }
        return !(this.httpLogFormat != null ? !this.httpLogFormat.equals(that.httpLogFormat) : that.httpLogFormat != null);
    }

    public int hashCode() {
        return Objects.hash(this.destination, this.httpCaptureCookies, this.httpCaptureHeaders, this.httpLogFormat, super.hashCode());
    }

    public class HttpCaptureHeadersNestedImpl<N>
    extends IngressControllerCaptureHTTPHeadersFluentImpl<AccessLoggingFluent.HttpCaptureHeadersNested<N>>
    implements AccessLoggingFluent.HttpCaptureHeadersNested<N>,
    Nested<N> {
        private final IngressControllerCaptureHTTPHeadersBuilder builder;

        HttpCaptureHeadersNestedImpl(IngressControllerCaptureHTTPHeaders item) {
            this.builder = new IngressControllerCaptureHTTPHeadersBuilder(this, item);
        }

        HttpCaptureHeadersNestedImpl() {
            this.builder = new IngressControllerCaptureHTTPHeadersBuilder(this);
        }

        @Override
        public N and() {
            return (N)AccessLoggingFluentImpl.this.withHttpCaptureHeaders(this.builder.build());
        }

        @Override
        public N endHttpCaptureHeaders() {
            return this.and();
        }
    }

    public class HttpCaptureCookiesNestedImpl<N>
    extends IngressControllerCaptureHTTPCookieFluentImpl<AccessLoggingFluent.HttpCaptureCookiesNested<N>>
    implements AccessLoggingFluent.HttpCaptureCookiesNested<N>,
    Nested<N> {
        private final IngressControllerCaptureHTTPCookieBuilder builder;
        private final int index;

        HttpCaptureCookiesNestedImpl(int index, IngressControllerCaptureHTTPCookie item) {
            this.index = index;
            this.builder = new IngressControllerCaptureHTTPCookieBuilder(this, item);
        }

        HttpCaptureCookiesNestedImpl() {
            this.index = -1;
            this.builder = new IngressControllerCaptureHTTPCookieBuilder(this);
        }

        @Override
        public N and() {
            return (N)AccessLoggingFluentImpl.this.setToHttpCaptureCookies(this.index, this.builder.build());
        }

        @Override
        public N endHttpCaptureCooky() {
            return this.and();
        }
    }

    public class DestinationNestedImpl<N>
    extends LoggingDestinationFluentImpl<AccessLoggingFluent.DestinationNested<N>>
    implements AccessLoggingFluent.DestinationNested<N>,
    Nested<N> {
        private final LoggingDestinationBuilder builder;

        DestinationNestedImpl(LoggingDestination item) {
            this.builder = new LoggingDestinationBuilder(this, item);
        }

        DestinationNestedImpl() {
            this.builder = new LoggingDestinationBuilder(this);
        }

        @Override
        public N and() {
            return (N)AccessLoggingFluentImpl.this.withDestination(this.builder.build());
        }

        @Override
        public N endDestination() {
            return this.and();
        }
    }
}

