package io.fabric8.openshift.api.model.machineconfiguration.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MachineOSBuilderReferenceFluent<A extends MachineOSBuilderReferenceFluent<A>> extends BaseFluent<A>{
  public MachineOSBuilderReferenceFluent() {
  }
  
  public MachineOSBuilderReferenceFluent(MachineOSBuilderReference instance) {
    this.copyInstance(instance);
  }
  private ObjectReferenceBuilder buildPod;
  private String imageBuilderType;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(MachineOSBuilderReference instance) {
    instance = (instance != null ? instance : new MachineOSBuilderReference());
    if (instance != null) {
          this.withBuildPod(instance.getBuildPod());
          this.withImageBuilderType(instance.getImageBuilderType());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public ObjectReference buildBuildPod() {
    return this.buildPod != null ? this.buildPod.build() : null;
  }
  
  public A withBuildPod(ObjectReference buildPod) {
    this._visitables.remove("buildPod");
    if (buildPod != null) {
        this.buildPod = new ObjectReferenceBuilder(buildPod);
        this._visitables.get("buildPod").add(this.buildPod);
    } else {
        this.buildPod = null;
        this._visitables.get("buildPod").remove(this.buildPod);
    }
    return (A) this;
  }
  
  public boolean hasBuildPod() {
    return this.buildPod != null;
  }
  
  public A withNewBuildPod(String group,String name,String namespace,String resource) {
    return (A)withBuildPod(new ObjectReference(group, name, namespace, resource));
  }
  
  public BuildPodNested<A> withNewBuildPod() {
    return new BuildPodNested(null);
  }
  
  public BuildPodNested<A> withNewBuildPodLike(ObjectReference item) {
    return new BuildPodNested(item);
  }
  
  public BuildPodNested<A> editBuildPod() {
    return withNewBuildPodLike(java.util.Optional.ofNullable(buildBuildPod()).orElse(null));
  }
  
  public BuildPodNested<A> editOrNewBuildPod() {
    return withNewBuildPodLike(java.util.Optional.ofNullable(buildBuildPod()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public BuildPodNested<A> editOrNewBuildPodLike(ObjectReference item) {
    return withNewBuildPodLike(java.util.Optional.ofNullable(buildBuildPod()).orElse(item));
  }
  
  public String getImageBuilderType() {
    return this.imageBuilderType;
  }
  
  public A withImageBuilderType(String imageBuilderType) {
    this.imageBuilderType = imageBuilderType;
    return (A) this;
  }
  
  public boolean hasImageBuilderType() {
    return this.imageBuilderType != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MachineOSBuilderReferenceFluent that = (MachineOSBuilderReferenceFluent) o;
    if (!java.util.Objects.equals(buildPod, that.buildPod)) return false;
    if (!java.util.Objects.equals(imageBuilderType, that.imageBuilderType)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(buildPod,  imageBuilderType,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (buildPod != null) { sb.append("buildPod:"); sb.append(buildPod + ","); }
    if (imageBuilderType != null) { sb.append("imageBuilderType:"); sb.append(imageBuilderType + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class BuildPodNested<N> extends ObjectReferenceFluent<BuildPodNested<N>> implements Nested<N>{
    BuildPodNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) MachineOSBuilderReferenceFluent.this.withBuildPod(builder.build());
    }
    
    public N endBuildPod() {
      return and();
    }
    
  
  }

}