package io.fabric8.openshift.api.model.machineconfiguration.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class MachineConfigNodeListBuilder extends MachineConfigNodeListFluent<MachineConfigNodeListBuilder> implements VisitableBuilder<MachineConfigNodeList,MachineConfigNodeListBuilder>{
  public MachineConfigNodeListBuilder() {
    this(new MachineConfigNodeList());
  }
  
  public MachineConfigNodeListBuilder(MachineConfigNodeListFluent<?> fluent) {
    this(fluent, new MachineConfigNodeList());
  }
  
  public MachineConfigNodeListBuilder(MachineConfigNodeListFluent<?> fluent,MachineConfigNodeList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public MachineConfigNodeListBuilder(MachineConfigNodeList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  MachineConfigNodeListFluent<?> fluent;
  
  public MachineConfigNodeList build() {
    MachineConfigNodeList buildable = new MachineConfigNodeList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}