package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class VSphereDiskBuilder extends VSphereDiskFluent<VSphereDiskBuilder> implements VisitableBuilder<VSphereDisk,VSphereDiskBuilder>{
  public VSphereDiskBuilder() {
    this(new VSphereDisk());
  }
  
  public VSphereDiskBuilder(VSphereDiskFluent<?> fluent) {
    this(fluent, new VSphereDisk());
  }
  
  public VSphereDiskBuilder(VSphereDiskFluent<?> fluent,VSphereDisk instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public VSphereDiskBuilder(VSphereDisk instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  VSphereDiskFluent<?> fluent;
  
  public VSphereDisk build() {
    VSphereDisk buildable = new VSphereDisk(fluent.getName(),fluent.getProvisioningMode(),fluent.getSizeGiB());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}