package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachineSpecBuilder extends MachineSpecFluentImpl<MachineSpecBuilder> implements VisitableBuilder<MachineSpec,MachineSpecBuilder>{
  public MachineSpecBuilder() {
    this(false);
  }
  public MachineSpecBuilder(Boolean validationEnabled) {
    this(new MachineSpec(), validationEnabled);
  }
  public MachineSpecBuilder(MachineSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public MachineSpecBuilder(MachineSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachineSpec(), validationEnabled);
  }
  public MachineSpecBuilder(MachineSpecFluent<?> fluent,MachineSpec instance) {
    this(fluent, instance, false);
  }
  public MachineSpecBuilder(MachineSpecFluent<?> fluent,MachineSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLifecycleHooks(instance.getLifecycleHooks()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withProviderID(instance.getProviderID()); 
    fluent.withProviderSpec(instance.getProviderSpec()); 
    fluent.withTaints(instance.getTaints()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public MachineSpecBuilder(MachineSpec instance) {
    this(instance,false);
  }
  public MachineSpecBuilder(MachineSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withLifecycleHooks(instance.getLifecycleHooks()); 
    this.withMetadata(instance.getMetadata()); 
    this.withProviderID(instance.getProviderID()); 
    this.withProviderSpec(instance.getProviderSpec()); 
    this.withTaints(instance.getTaints()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  MachineSpecFluent<?> fluent;
  Boolean validationEnabled;
  public MachineSpec build() {
    MachineSpec buildable = new MachineSpec(fluent.getLifecycleHooks(),fluent.getMetadata(),fluent.getProviderID(),fluent.getProviderSpec(),fluent.getTaints());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}