package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachineHealthCheckStatusBuilder extends MachineHealthCheckStatusFluentImpl<MachineHealthCheckStatusBuilder> implements VisitableBuilder<MachineHealthCheckStatus,MachineHealthCheckStatusBuilder>{
  public MachineHealthCheckStatusBuilder() {
    this(false);
  }
  public MachineHealthCheckStatusBuilder(Boolean validationEnabled) {
    this(new MachineHealthCheckStatus(), validationEnabled);
  }
  public MachineHealthCheckStatusBuilder(MachineHealthCheckStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public MachineHealthCheckStatusBuilder(MachineHealthCheckStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachineHealthCheckStatus(), validationEnabled);
  }
  public MachineHealthCheckStatusBuilder(MachineHealthCheckStatusFluent<?> fluent,MachineHealthCheckStatus instance) {
    this(fluent, instance, false);
  }
  public MachineHealthCheckStatusBuilder(MachineHealthCheckStatusFluent<?> fluent,MachineHealthCheckStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConditions(instance.getConditions()); 
    fluent.withCurrentHealthy(instance.getCurrentHealthy()); 
    fluent.withExpectedMachines(instance.getExpectedMachines()); 
    fluent.withRemediationsAllowed(instance.getRemediationsAllowed()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public MachineHealthCheckStatusBuilder(MachineHealthCheckStatus instance) {
    this(instance,false);
  }
  public MachineHealthCheckStatusBuilder(MachineHealthCheckStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withConditions(instance.getConditions()); 
    this.withCurrentHealthy(instance.getCurrentHealthy()); 
    this.withExpectedMachines(instance.getExpectedMachines()); 
    this.withRemediationsAllowed(instance.getRemediationsAllowed()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  MachineHealthCheckStatusFluent<?> fluent;
  Boolean validationEnabled;
  public MachineHealthCheckStatus build() {
    MachineHealthCheckStatus buildable = new MachineHealthCheckStatus(fluent.getConditions(),fluent.getCurrentHealthy(),fluent.getExpectedMachines(),fluent.getRemediationsAllowed());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}