package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ConsolePluginBuilder extends ConsolePluginFluent<ConsolePluginBuilder> implements VisitableBuilder<ConsolePlugin,ConsolePluginBuilder>{
  public ConsolePluginBuilder() {
    this(new ConsolePlugin());
  }
  
  public ConsolePluginBuilder(ConsolePluginFluent<?> fluent) {
    this(fluent, new ConsolePlugin());
  }
  
  public ConsolePluginBuilder(ConsolePluginFluent<?> fluent,ConsolePlugin instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ConsolePluginBuilder(ConsolePlugin instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ConsolePluginFluent<?> fluent;
  
  public ConsolePlugin build() {
    ConsolePlugin buildable = new ConsolePlugin(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}