package io.fabric8.openshift.api.model.console.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ConsoleNotificationSpecFluentImpl<A extends ConsoleNotificationSpecFluent<A>> extends BaseFluent<A> implements ConsoleNotificationSpecFluent<A>{
  public ConsoleNotificationSpecFluentImpl() {
  }
  public ConsoleNotificationSpecFluentImpl(ConsoleNotificationSpec instance) {
    this.withBackgroundColor(instance.getBackgroundColor()); 
    this.withColor(instance.getColor()); 
    this.withLink(instance.getLink()); 
    this.withLocation(instance.getLocation()); 
    this.withText(instance.getText()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String backgroundColor;
  private String color;
  private LinkBuilder link;
  private String location;
  private String text;
  private Map<String,Object> additionalProperties;
  public String getBackgroundColor() {
    return this.backgroundColor;
  }
  public A withBackgroundColor(String backgroundColor) {
    this.backgroundColor=backgroundColor; return (A) this;
  }
  public Boolean hasBackgroundColor() {
    return this.backgroundColor != null;
  }
  public String getColor() {
    return this.color;
  }
  public A withColor(String color) {
    this.color=color; return (A) this;
  }
  public Boolean hasColor() {
    return this.color != null;
  }
  
  /**
   * This method has been deprecated, please use method buildLink instead.
   * @return The buildable object.
   */
  @Deprecated
  public Link getLink() {
    return this.link!=null ?this.link.build():null;
  }
  public Link buildLink() {
    return this.link!=null ?this.link.build():null;
  }
  public A withLink(Link link) {
    _visitables.get("link").remove(this.link);
    if (link!=null){ this.link= new LinkBuilder(link); _visitables.get("link").add(this.link);} else { this.link = null; _visitables.get("link").remove(this.link); } return (A) this;
  }
  public Boolean hasLink() {
    return this.link != null;
  }
  public A withNewLink(String href,String text) {
    return (A)withLink(new Link(href, text));
  }
  public ConsoleNotificationSpecFluent.LinkNested<A> withNewLink() {
    return new ConsoleNotificationSpecFluentImpl.LinkNestedImpl();
  }
  public ConsoleNotificationSpecFluent.LinkNested<A> withNewLinkLike(Link item) {
    return new ConsoleNotificationSpecFluentImpl.LinkNestedImpl(item);
  }
  public ConsoleNotificationSpecFluent.LinkNested<A> editLink() {
    return withNewLinkLike(getLink());
  }
  public ConsoleNotificationSpecFluent.LinkNested<A> editOrNewLink() {
    return withNewLinkLike(getLink() != null ? getLink(): new LinkBuilder().build());
  }
  public ConsoleNotificationSpecFluent.LinkNested<A> editOrNewLinkLike(Link item) {
    return withNewLinkLike(getLink() != null ? getLink(): item);
  }
  public String getLocation() {
    return this.location;
  }
  public A withLocation(String location) {
    this.location=location; return (A) this;
  }
  public Boolean hasLocation() {
    return this.location != null;
  }
  public String getText() {
    return this.text;
  }
  public A withText(String text) {
    this.text=text; return (A) this;
  }
  public Boolean hasText() {
    return this.text != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ConsoleNotificationSpecFluentImpl that = (ConsoleNotificationSpecFluentImpl) o;
    if (backgroundColor != null ? !backgroundColor.equals(that.backgroundColor) :that.backgroundColor != null) return false;
    if (color != null ? !color.equals(that.color) :that.color != null) return false;
    if (link != null ? !link.equals(that.link) :that.link != null) return false;
    if (location != null ? !location.equals(that.location) :that.location != null) return false;
    if (text != null ? !text.equals(that.text) :that.text != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(backgroundColor,  color,  link,  location,  text,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (backgroundColor != null) { sb.append("backgroundColor:"); sb.append(backgroundColor + ","); }
    if (color != null) { sb.append("color:"); sb.append(color + ","); }
    if (link != null) { sb.append("link:"); sb.append(link + ","); }
    if (location != null) { sb.append("location:"); sb.append(location + ","); }
    if (text != null) { sb.append("text:"); sb.append(text + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class LinkNestedImpl<N> extends LinkFluentImpl<ConsoleNotificationSpecFluent.LinkNested<N>> implements ConsoleNotificationSpecFluent.LinkNested<N>,Nested<N>{
    LinkNestedImpl(Link item) {
      this.builder = new LinkBuilder(this, item);
    }
    LinkNestedImpl() {
      this.builder = new LinkBuilder(this);
    }
    LinkBuilder builder;
    public N and() {
      return (N) ConsoleNotificationSpecFluentImpl.this.withLink(builder.build());
    }
    public N endLink() {
      return and();
    }
    
  }
  
}