/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers.user;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.WritableOperation;
import io.fabric8.openshift.api.model.User;
import io.fabric8.openshift.api.model.UserBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.user.UserOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class UserHandler
implements ResourceHandler<User, UserBuilder> {
    public String getKind() {
        return User.class.getSimpleName();
    }

    public String getApiVersion() {
        return "user.openshift.io/v1";
    }

    public User create(OkHttpClient client, Config config, String namespace, User item, boolean dryRun) {
        return (User)((WritableOperation)new UserOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).dryRun(dryRun)).create((Object[])new User[0]);
    }

    public User replace(OkHttpClient client, Config config, String namespace, User item, boolean dryRun) {
        return (User)((WritableOperation)((Resource)new UserOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace((Object)item);
    }

    public User reload(OkHttpClient client, Config config, String namespace, User item) {
        return (User)((Gettable)((Resource)new UserOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public UserBuilder edit(User item) {
        return new UserBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, User item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new UserOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, User item, Watcher<User> watcher) {
        return ((Resource)new UserOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, User item, String resourceVersion, Watcher<User> watcher) {
        return ((Resource)new UserOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, User item, ListOptions options, Watcher<User> watcher) {
        return ((Resource)new UserOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public User waitUntilReady(OkHttpClient client, Config config, String namespace, User item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (User)((Resource)new UserOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public User waitUntilCondition(OkHttpClient client, Config config, String namespace, User item, Predicate<User> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (User)((Resource)new UserOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

