/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers.tuned;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.WritableOperation;
import io.fabric8.openshift.api.model.tuned.v1.Profile;
import io.fabric8.openshift.api.model.tuned.v1.ProfileBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.tuned.ProfileOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class ProfileHandler
implements ResourceHandler<Profile, ProfileBuilder> {
    public String getKind() {
        return Profile.class.getSimpleName();
    }

    public String getApiVersion() {
        return "tuned.openshift.io/v1";
    }

    public Profile create(OkHttpClient client, Config config, String namespace, Profile item, boolean dryRun) {
        return (Profile)((WritableOperation)new ProfileOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).dryRun(dryRun)).create((Object[])new Profile[0]);
    }

    public Profile replace(OkHttpClient client, Config config, String namespace, Profile item, boolean dryRun) {
        return (Profile)((WritableOperation)((Resource)new ProfileOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace((Object)item);
    }

    public Profile reload(OkHttpClient client, Config config, String namespace, Profile item) {
        return (Profile)((Gettable)((Resource)new ProfileOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public ProfileBuilder edit(Profile item) {
        return new ProfileBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, Profile item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new ProfileOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Profile item, Watcher<Profile> watcher) {
        return ((Resource)new ProfileOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Profile item, String resourceVersion, Watcher<Profile> watcher) {
        return ((Resource)new ProfileOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Profile item, ListOptions options, Watcher<Profile> watcher) {
        return ((Resource)new ProfileOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public Profile waitUntilReady(OkHttpClient client, Config config, String namespace, Profile item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Profile)((Resource)new ProfileOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public Profile waitUntilCondition(OkHttpClient client, Config config, String namespace, Profile item, Predicate<Profile> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Profile)((Resource)new ProfileOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

