/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers.image;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.WritableOperation;
import io.fabric8.openshift.api.model.ImageTag;
import io.fabric8.openshift.api.model.ImageTagBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.image.ImageTagOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class ImageTagHandler
implements ResourceHandler<ImageTag, ImageTagBuilder> {
    public String getKind() {
        return ImageTag.class.getSimpleName();
    }

    public String getApiVersion() {
        return "image.openshift.io/v1";
    }

    public ImageTag create(OkHttpClient client, Config config, String namespace, ImageTag item, boolean dryRun) {
        return (ImageTag)((WritableOperation)new ImageTagOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).dryRun(dryRun)).create((Object[])new ImageTag[0]);
    }

    public ImageTag replace(OkHttpClient client, Config config, String namespace, ImageTag item, boolean dryRun) {
        return (ImageTag)((WritableOperation)((Resource)new ImageTagOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace((Object)item);
    }

    public ImageTag reload(OkHttpClient client, Config config, String namespace, ImageTag item) {
        return (ImageTag)((Gettable)((Resource)new ImageTagOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public ImageTagBuilder edit(ImageTag item) {
        return new ImageTagBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, ImageTag item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new ImageTagOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ImageTag item, Watcher<ImageTag> watcher) {
        return ((Resource)new ImageTagOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ImageTag item, String resourceVersion, Watcher<ImageTag> watcher) {
        return ((Resource)new ImageTagOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ImageTag item, ListOptions options, Watcher<ImageTag> watcher) {
        return ((Resource)new ImageTagOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public ImageTag waitUntilReady(OkHttpClient client, Config config, String namespace, ImageTag item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ImageTag)((Resource)new ImageTagOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public ImageTag waitUntilCondition(OkHttpClient client, Config config, String namespace, ImageTag item, Predicate<ImageTag> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ImageTag)((Resource)new ImageTagOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

