/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers.config;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.WritableOperation;
import io.fabric8.openshift.api.model.Ingress;
import io.fabric8.openshift.api.model.IngressBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.config.IngressOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class IngressHandler
implements ResourceHandler<Ingress, IngressBuilder> {
    public String getKind() {
        return Ingress.class.getSimpleName();
    }

    public String getApiVersion() {
        return "config.openshift.io/v1";
    }

    public Ingress create(OkHttpClient client, Config config, String namespace, Ingress item, boolean dryRun) {
        return (Ingress)((WritableOperation)new IngressOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).dryRun(dryRun)).create((Object[])new Ingress[0]);
    }

    public Ingress replace(OkHttpClient client, Config config, String namespace, Ingress item, boolean dryRun) {
        return (Ingress)((WritableOperation)((Resource)new IngressOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace((Object)item);
    }

    public Ingress reload(OkHttpClient client, Config config, String namespace, Ingress item) {
        return (Ingress)((Gettable)((Resource)new IngressOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public IngressBuilder edit(Ingress item) {
        return new IngressBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, Ingress item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new IngressOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Ingress item, Watcher<Ingress> watcher) {
        return ((Resource)new IngressOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Ingress item, String resourceVersion, Watcher<Ingress> watcher) {
        return ((Resource)new IngressOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Ingress item, ListOptions options, Watcher<Ingress> watcher) {
        return ((Resource)new IngressOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public Ingress waitUntilReady(OkHttpClient client, Config config, String namespace, Ingress item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Ingress)((Resource)new IngressOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public Ingress waitUntilCondition(OkHttpClient client, Config config, String namespace, Ingress item, Predicate<Ingress> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Ingress)((Resource)new IngressOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

