/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.ListOptionsBuilder;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.client.ClientContext;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.dsl.base.OperationSupport;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.openshift.api.model.ProjectRequest;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.OpenshiftClientContext;
import io.fabric8.openshift.client.dsl.ProjectRequestOperation;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class ProjectRequestsOperationImpl
extends OperationSupport
implements ProjectRequestOperation {
    public ProjectRequestsOperationImpl(OpenshiftClientContext clientContext) {
        this(HasMetadataOperationsImpl.defaultContext((ClientContext)clientContext));
    }

    public ProjectRequestsOperationImpl(OperationContext context) {
        super(context.withApiGroupName("project.openshift.io").withPlural("projectrequests"));
    }

    public boolean isResourceNamespaced() {
        return false;
    }

    public URL getRootUrl() {
        if (Utils.isNullOrEmpty((String)this.context.getApiGroupName())) {
            try {
                return new URL(OpenShiftConfig.wrap(this.getConfig()).getOpenShiftUrl());
            }
            catch (MalformedURLException e) {
                throw KubernetesClientException.launderThrowable((Throwable)e);
            }
        }
        return super.getRootUrl();
    }

    private ProjectRequest updateApiVersion(ProjectRequest p) {
        if (p.getApiVersion() == null) {
            p.setApiVersion(this.apiGroupVersion);
        }
        return p;
    }

    public ProjectRequest create(ProjectRequest ... resources) {
        try {
            if (resources.length > 1) {
                throw new IllegalArgumentException("Too many items to create.");
            }
            if (resources.length == 1) {
                return (ProjectRequest)this.handleCreate(this.updateApiVersion(resources[0]), ProjectRequest.class);
            }
            if (this.getItem() == null) {
                throw new IllegalArgumentException("Nothing to create.");
            }
            return (ProjectRequest)this.handleCreate(this.updateApiVersion(this.getItem()), ProjectRequest.class);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable((Throwable)ie);
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    public ProjectRequest create(ProjectRequest resource) {
        return this.create(new ProjectRequest[]{resource});
    }

    public Status list() {
        return this.list(new ListOptions());
    }

    public Status list(Integer limitVal, String continueVal) {
        return this.list(((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withLimit(Long.valueOf(Long.parseLong(limitVal.toString())))).withContinue(continueVal)).build());
    }

    public Status list(ListOptions listOptions) {
        try {
            URLUtils.URLBuilder urlBuilder = new URLUtils.URLBuilder(this.getNamespacedUrl().toString());
            if (listOptions.getLimit() != null) {
                urlBuilder.addQueryParameter("limit", listOptions.getLimit().toString());
            }
            if (listOptions.getContinue() != null) {
                urlBuilder.addQueryParameter("continue", listOptions.getContinue());
            }
            if (listOptions.getResourceVersion() != null) {
                urlBuilder.addQueryParameter("resourceVersion", listOptions.getResourceVersion());
            }
            if (listOptions.getFieldSelector() != null) {
                urlBuilder.addQueryParameter("fieldSelector", listOptions.getFieldSelector());
            }
            if (listOptions.getLabelSelector() != null) {
                urlBuilder.addQueryParameter("labelSelector", listOptions.getLabelSelector());
            }
            if (listOptions.getTimeoutSeconds() != null) {
                urlBuilder.addQueryParameter("timeoutSeconds", listOptions.getTimeoutSeconds().toString());
            }
            if (listOptions.getAllowWatchBookmarks() != null) {
                urlBuilder.addQueryParameter("allowWatchBookmarks", listOptions.getAllowWatchBookmarks().toString());
            }
            return (Status)this.handleGet(urlBuilder.build(), Status.class);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable((Throwable)ie);
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    public ProjectRequest getItem() {
        return (ProjectRequest)this.context.getItem();
    }
}

