/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client;

import io.fabric8.kubernetes.api.model.ComponentStatus;
import io.fabric8.kubernetes.api.model.ComponentStatusList;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.RootPaths;
import io.fabric8.kubernetes.client.BaseKubernetesClient;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.ExtensionsAPIGroupClient;
import io.fabric8.kubernetes.client.Handlers;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.RequestConfig;
import io.fabric8.kubernetes.client.VersionInfo;
import io.fabric8.kubernetes.client.WithRequestCallable;
import io.fabric8.kubernetes.client.dsl.CreateOrDeleteable;
import io.fabric8.kubernetes.client.dsl.FunctionCallable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.InOutCreateable;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.Nameable;
import io.fabric8.kubernetes.client.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.Namespaceable;
import io.fabric8.kubernetes.client.dsl.NamespacedInOutCreateable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ParameterMixedOperation;
import io.fabric8.kubernetes.client.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.internal.core.v1.ComponentStatusOperationsImpl;
import io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectorBuilder;
import io.fabric8.kubernetes.client.utils.HttpClientUtils;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.openshift.api.model.BrokerTemplateInstance;
import io.fabric8.openshift.api.model.BrokerTemplateInstanceList;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.ClusterNetwork;
import io.fabric8.openshift.api.model.ClusterNetworkList;
import io.fabric8.openshift.api.model.ClusterRole;
import io.fabric8.openshift.api.model.ClusterRoleBinding;
import io.fabric8.openshift.api.model.ClusterRoleBindingList;
import io.fabric8.openshift.api.model.ClusterRoleList;
import io.fabric8.openshift.api.model.ClusterVersion;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigList;
import io.fabric8.openshift.api.model.EgressNetworkPolicy;
import io.fabric8.openshift.api.model.EgressNetworkPolicyList;
import io.fabric8.openshift.api.model.Group;
import io.fabric8.openshift.api.model.GroupList;
import io.fabric8.openshift.api.model.HelmChartRepository;
import io.fabric8.openshift.api.model.HelmChartRepositoryList;
import io.fabric8.openshift.api.model.HostSubnet;
import io.fabric8.openshift.api.model.HostSubnetList;
import io.fabric8.openshift.api.model.Identity;
import io.fabric8.openshift.api.model.IdentityList;
import io.fabric8.openshift.api.model.Image;
import io.fabric8.openshift.api.model.ImageList;
import io.fabric8.openshift.api.model.ImageSignature;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamImage;
import io.fabric8.openshift.api.model.ImageStreamImport;
import io.fabric8.openshift.api.model.ImageStreamList;
import io.fabric8.openshift.api.model.ImageStreamMapping;
import io.fabric8.openshift.api.model.ImageStreamTag;
import io.fabric8.openshift.api.model.ImageStreamTagList;
import io.fabric8.openshift.api.model.ImageTag;
import io.fabric8.openshift.api.model.ImageTagList;
import io.fabric8.openshift.api.model.LocalResourceAccessReview;
import io.fabric8.openshift.api.model.LocalSubjectAccessReview;
import io.fabric8.openshift.api.model.NetNamespace;
import io.fabric8.openshift.api.model.NetNamespaceList;
import io.fabric8.openshift.api.model.OAuthAccessToken;
import io.fabric8.openshift.api.model.OAuthAccessTokenList;
import io.fabric8.openshift.api.model.OAuthAuthorizeToken;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenList;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.OAuthClientAuthorization;
import io.fabric8.openshift.api.model.OAuthClientAuthorizationList;
import io.fabric8.openshift.api.model.OAuthClientList;
import io.fabric8.openshift.api.model.PodSecurityPolicyReview;
import io.fabric8.openshift.api.model.PodSecurityPolicySelfSubjectReview;
import io.fabric8.openshift.api.model.PodSecurityPolicySubjectReview;
import io.fabric8.openshift.api.model.RangeAllocation;
import io.fabric8.openshift.api.model.RangeAllocationList;
import io.fabric8.openshift.api.model.ResourceAccessReview;
import io.fabric8.openshift.api.model.ResourceAccessReviewResponse;
import io.fabric8.openshift.api.model.Role;
import io.fabric8.openshift.api.model.RoleBinding;
import io.fabric8.openshift.api.model.RoleBindingList;
import io.fabric8.openshift.api.model.RoleBindingRestriction;
import io.fabric8.openshift.api.model.RoleBindingRestrictionList;
import io.fabric8.openshift.api.model.RoleList;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteList;
import io.fabric8.openshift.api.model.SecurityContextConstraints;
import io.fabric8.openshift.api.model.SecurityContextConstraintsList;
import io.fabric8.openshift.api.model.SelfSubjectRulesReview;
import io.fabric8.openshift.api.model.SubjectAccessReview;
import io.fabric8.openshift.api.model.SubjectAccessReviewResponse;
import io.fabric8.openshift.api.model.SubjectRulesReview;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.api.model.TemplateInstance;
import io.fabric8.openshift.api.model.TemplateInstanceList;
import io.fabric8.openshift.api.model.TemplateList;
import io.fabric8.openshift.api.model.User;
import io.fabric8.openshift.api.model.UserIdentityMapping;
import io.fabric8.openshift.api.model.UserList;
import io.fabric8.openshift.api.model.UserOAuthAccessToken;
import io.fabric8.openshift.api.model.UserOAuthAccessTokenList;
import io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.CredentialsRequest;
import io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.CredentialsRequestList;
import io.fabric8.openshift.api.model.miscellaneous.cncf.cni.v1.NetworkAttachmentDefinition;
import io.fabric8.openshift.api.model.miscellaneous.cncf.cni.v1.NetworkAttachmentDefinitionList;
import io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.Config;
import io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ConfigList;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.BareMetalHost;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.BareMetalHostList;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.OperatorPKI;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.OperatorPKIList;
import io.fabric8.openshift.client.NamespacedOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftClusterAutoscalingAPIGroupClient;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.OpenShiftConfigAPIGroupClient;
import io.fabric8.openshift.client.OpenShiftConfigBuilder;
import io.fabric8.openshift.client.OpenShiftConsoleAPIGroupClient;
import io.fabric8.openshift.client.OpenShiftHandlers;
import io.fabric8.openshift.client.OpenShiftMachineAPIGroupClient;
import io.fabric8.openshift.client.OpenShiftMachineConfigurationAPIGroupClient;
import io.fabric8.openshift.client.OpenShiftMonitoringAPIGroupClient;
import io.fabric8.openshift.client.OpenShiftOperatorAPIGroupClient;
import io.fabric8.openshift.client.OpenShiftOperatorHubAPIGroupClient;
import io.fabric8.openshift.client.OpenShiftQuotaAPIGroupClient;
import io.fabric8.openshift.client.OpenShiftStorageVersionMigratorApiGroupClient;
import io.fabric8.openshift.client.OpenShiftTunedAPIGroupClient;
import io.fabric8.openshift.client.OpenShiftWhereaboutsAPIGroupClient;
import io.fabric8.openshift.client.OpenshiftAdapterSupport;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import io.fabric8.openshift.client.dsl.BuildResource;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import io.fabric8.openshift.client.dsl.MachineConfigurationAPIGroupDSL;
import io.fabric8.openshift.client.dsl.NameableCreateOrDeleteable;
import io.fabric8.openshift.client.dsl.OpenShiftClusterAutoscalingAPIGroupDSL;
import io.fabric8.openshift.client.dsl.OpenShiftConfigAPIGroupDSL;
import io.fabric8.openshift.client.dsl.OpenShiftConsoleAPIGroupDSL;
import io.fabric8.openshift.client.dsl.OpenShiftMachineAPIGroupDSL;
import io.fabric8.openshift.client.dsl.OpenShiftMonitoringAPIGroupDSL;
import io.fabric8.openshift.client.dsl.OpenShiftOperatorAPIGroupDSL;
import io.fabric8.openshift.client.dsl.OpenShiftOperatorHubAPIGroupDSL;
import io.fabric8.openshift.client.dsl.OpenShiftQuotaAPIGroupDSL;
import io.fabric8.openshift.client.dsl.OpenShiftStorageVersionMigratorApiGroupDSL;
import io.fabric8.openshift.client.dsl.OpenShiftTunedAPIGroupDSL;
import io.fabric8.openshift.client.dsl.OpenShiftWhereaboutsAPIGroupDSL;
import io.fabric8.openshift.client.dsl.ProjectOperation;
import io.fabric8.openshift.client.dsl.ProjectRequestOperation;
import io.fabric8.openshift.client.dsl.TemplateResource;
import io.fabric8.openshift.client.dsl.internal.ProjectRequestsOperationImpl;
import io.fabric8.openshift.client.dsl.internal.apps.DeploymentConfigOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.authorization.ClusterRoleBindingOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.authorization.RoleBindingOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.authorization.RoleOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.build.BuildConfigOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.build.BuildOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.core.NetworkAttachmentDefinitionOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.core.TemplateOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.oauth.OAuthAccessTokenOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.oauth.OAuthAuthorizeTokenOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.oauth.OAuthClientOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.project.ProjectOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.security.SecurityContextConstraintsOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.user.GroupOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.user.UserOperationsImpl;
import io.fabric8.openshift.client.internal.OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import okhttp3.OkHttpClient;

public class DefaultOpenShiftClient
extends BaseKubernetesClient<NamespacedOpenShiftClient>
implements NamespacedOpenShiftClient {
    public static final String OPENSHIFT_VERSION_ENDPOINT = "version/openshift";
    private final URL openShiftUrl;

    public DefaultOpenShiftClient() {
        this(new OpenShiftConfigBuilder().build());
    }

    public DefaultOpenShiftClient(String masterUrl) {
        this(((OpenShiftConfigBuilder)new OpenShiftConfigBuilder().withMasterUrl(masterUrl)).build());
    }

    public DefaultOpenShiftClient(io.fabric8.kubernetes.client.Config config) {
        this(new OpenShiftConfig(config));
    }

    public DefaultOpenShiftClient(OpenShiftConfig config) {
        this(HttpClientUtils.createHttpClient((io.fabric8.kubernetes.client.Config)config), config);
    }

    public DefaultOpenShiftClient(OkHttpClient httpClient, OpenShiftConfig config) {
        super(httpClient, (io.fabric8.kubernetes.client.Config)config);
        try {
            this.openShiftUrl = new URL(config.getOpenShiftUrl());
        }
        catch (MalformedURLException e) {
            throw new KubernetesClientException("Could not create client", (Throwable)e);
        }
    }

    public static DefaultOpenShiftClient fromConfig(String config) {
        return new DefaultOpenShiftClient((OpenShiftConfig)((Object)Serialization.unmarshal((String)config, OpenShiftConfig.class)));
    }

    public static DefaultOpenShiftClient fromConfig(InputStream is) {
        return new DefaultOpenShiftClient((OpenShiftConfig)((Object)Serialization.unmarshal((InputStream)is, OpenShiftConfig.class)));
    }

    @Override
    public URL getOpenshiftUrl() {
        return this.openShiftUrl;
    }

    public OpenShiftConfig getConfiguration() {
        return OpenShiftConfig.wrap(super.getConfiguration());
    }

    @Override
    public OpenShiftConfigAPIGroupDSL config() {
        return (OpenShiftConfigAPIGroupDSL)this.adapt(OpenShiftConfigAPIGroupClient.class);
    }

    @Override
    public OpenShiftConsoleAPIGroupDSL console() {
        return (OpenShiftConsoleAPIGroupDSL)this.adapt(OpenShiftConsoleAPIGroupClient.class);
    }

    @Override
    public OpenShiftClusterAutoscalingAPIGroupDSL clusterAutoscaling() {
        return (OpenShiftClusterAutoscalingAPIGroupDSL)this.adapt(OpenShiftClusterAutoscalingAPIGroupClient.class);
    }

    @Override
    public OpenShiftOperatorAPIGroupDSL operator() {
        return (OpenShiftOperatorAPIGroupDSL)this.adapt(OpenShiftOperatorAPIGroupClient.class);
    }

    @Override
    public OpenShiftOperatorHubAPIGroupDSL operatorHub() {
        return (OpenShiftOperatorHubAPIGroupDSL)this.adapt(OpenShiftOperatorHubAPIGroupClient.class);
    }

    public MixedOperation<ComponentStatus, ComponentStatusList, Resource<ComponentStatus>> componentstatuses() {
        return new ComponentStatusOperationsImpl(this.httpClient, (io.fabric8.kubernetes.client.Config)this.getConfiguration());
    }

    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> load(InputStream is) {
        return new OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.httpClient, this.getConfiguration(), is);
    }

    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(KubernetesResourceList item) {
        return new OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.httpClient, this.getConfiguration(), item);
    }

    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(String s) {
        return new OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.httpClient, this.getConfiguration(), s);
    }

    @Override
    public MixedOperation<Build, BuildList, BuildResource<Build, LogWatch>> builds() {
        return new BuildOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<BuildConfig, BuildConfigList, BuildConfigResource<BuildConfig, Void, Build>> buildConfigs() {
        return new BuildConfigOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<CredentialsRequest, CredentialsRequestList, Resource<CredentialsRequest>> credentialsRequests() {
        return OpenShiftHandlers.getOperation(CredentialsRequest.class, CredentialsRequestList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<DeploymentConfig, DeploymentConfigList, DeployableScalableResource<DeploymentConfig>> deploymentConfigs() {
        return new DeploymentConfigOperationsImpl(this.httpClient, this.getConfiguration());
    }

    public MixedOperation<Group, GroupList, Resource<Group>> groups() {
        return new GroupOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<HelmChartRepository, HelmChartRepositoryList, Resource<HelmChartRepository>> helmChartRepositories() {
        return OpenShiftHandlers.getOperation(HelmChartRepository.class, HelmChartRepositoryList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<Image, ImageList, Resource<Image>> images() {
        return OpenShiftHandlers.getOperation(Image.class, ImageList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<ImageTag, ImageTagList, Resource<ImageTag>> imageTags() {
        return OpenShiftHandlers.getOperation(ImageTag.class, ImageTagList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<ImageStream, ImageStreamList, Resource<ImageStream>> imageStreams() {
        return OpenShiftHandlers.getOperation(ImageStream.class, ImageStreamList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<ImageStreamTag, ImageStreamTagList, Resource<ImageStreamTag>> imageStreamTags() {
        return OpenShiftHandlers.getOperation(ImageStreamTag.class, ImageStreamTagList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NamespacedInOutCreateable<ImageStreamImport, ImageStreamImport> imageStreamImports() {
        return Handlers.getNamespacedHasMetadataCreateOnlyOperation(ImageStreamImport.class, (OkHttpClient)this.httpClient, (io.fabric8.kubernetes.client.Config)this.getConfiguration());
    }

    @Override
    public NamespacedInOutCreateable<ImageStreamMapping, ImageStreamMapping> imageStreamMappings() {
        return Handlers.getNamespacedHasMetadataCreateOnlyOperation(ImageStreamMapping.class, (OkHttpClient)this.httpClient, (io.fabric8.kubernetes.client.Config)this.getConfiguration());
    }

    @Override
    public Namespaceable<Nameable<? extends Gettable<ImageStreamImage>>> imageStreamImages() {
        HasMetadataOperation operation = Handlers.getNonListingOperation(ImageStreamImage.class, (OkHttpClient)this.httpClient, (io.fabric8.kubernetes.client.Config)this.getConfiguration());
        return arg_0 -> ((HasMetadataOperation)operation).inNamespace(arg_0);
    }

    @Override
    public NameableCreateOrDeleteable imageSignatures() {
        final HasMetadataOperation operation = Handlers.getNonListingOperation(ImageSignature.class, (OkHttpClient)this.httpClient, (io.fabric8.kubernetes.client.Config)this.getConfiguration());
        return new NameableCreateOrDeleteable(){

            public Boolean delete() {
                return operation.delete();
            }

            public ImageSignature create(ImageSignature item) {
                return (ImageSignature)operation.create((Object)item);
            }

            public ImageSignature create(ImageSignature ... item) {
                return (ImageSignature)operation.create((Object[])item);
            }

            public CreateOrDeleteable<ImageSignature> withName(String name) {
                return operation.withName(name);
            }
        };
    }

    @Override
    public NonNamespaceOperation<Config, ConfigList, Resource<Config>> imageRegistryOperatorConfigs() {
        return OpenShiftHandlers.getOperation(Config.class, ConfigList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<NetworkAttachmentDefinition, NetworkAttachmentDefinitionList, Resource<NetworkAttachmentDefinition>> networkAttachmentDefinitions() {
        return new NetworkAttachmentDefinitionOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<OAuthAccessToken, OAuthAccessTokenList, Resource<OAuthAccessToken>> oAuthAccessTokens() {
        return new OAuthAccessTokenOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<OAuthAuthorizeToken, OAuthAuthorizeTokenList, Resource<OAuthAuthorizeToken>> oAuthAuthorizeTokens() {
        return new OAuthAuthorizeTokenOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<OAuthClient, OAuthClientList, Resource<OAuthClient>> oAuthClients() {
        return new OAuthClientOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public NamespacedInOutCreateable<PodSecurityPolicyReview, PodSecurityPolicyReview> podSecurityPolicyReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(PodSecurityPolicyReview.class, PodSecurityPolicyReview.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<OAuthClientAuthorization, OAuthClientAuthorizationList, Resource<OAuthClientAuthorization>> oAuthClientAuthorizations() {
        return OpenShiftHandlers.getOperation(OAuthClientAuthorization.class, OAuthClientAuthorizationList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<OperatorPKI, OperatorPKIList, Resource<OperatorPKI>> operatorPKIs() {
        return OpenShiftHandlers.getOperation(OperatorPKI.class, OperatorPKIList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NamespacedInOutCreateable<PodSecurityPolicySelfSubjectReview, PodSecurityPolicySelfSubjectReview> podSecurityPolicySelfSubjectReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(PodSecurityPolicySelfSubjectReview.class, PodSecurityPolicySelfSubjectReview.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NamespacedInOutCreateable<PodSecurityPolicySubjectReview, PodSecurityPolicySubjectReview> podSecurityPolicySubjectReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(PodSecurityPolicySubjectReview.class, PodSecurityPolicySubjectReview.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public ProjectOperation projects() {
        return new ProjectOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public OpenShiftQuotaAPIGroupDSL quotas() {
        return (OpenShiftQuotaAPIGroupDSL)this.adapt(OpenShiftQuotaAPIGroupClient.class);
    }

    @Override
    public NonNamespaceOperation<RangeAllocation, RangeAllocationList, Resource<RangeAllocation>> rangeAllocations() {
        return OpenShiftHandlers.getOperation(RangeAllocation.class, RangeAllocationList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<SecurityContextConstraints, SecurityContextConstraintsList, Resource<SecurityContextConstraints>> securityContextConstraints() {
        return new SecurityContextConstraintsOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public ProjectRequestOperation projectrequests() {
        return new ProjectRequestsOperationImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<Role, RoleList, Resource<Role>> roles() {
        return new RoleOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<RoleBinding, RoleBindingList, Resource<RoleBinding>> roleBindings() {
        return new RoleBindingOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<Route, RouteList, Resource<Route>> routes() {
        return OpenShiftHandlers.getOperation(Route.class, RouteList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public ParameterMixedOperation<Template, TemplateList, TemplateResource<Template, KubernetesList>> templates() {
        return new TemplateOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<TemplateInstance, TemplateInstanceList, Resource<TemplateInstance>> templateInstances() {
        return OpenShiftHandlers.getOperation(TemplateInstance.class, TemplateInstanceList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public OpenShiftTunedAPIGroupDSL tuned() {
        return (OpenShiftTunedAPIGroupDSL)this.adapt(OpenShiftTunedAPIGroupClient.class);
    }

    @Override
    public NonNamespaceOperation<BrokerTemplateInstance, BrokerTemplateInstanceList, Resource<BrokerTemplateInstance>> brokerTemplateInstances() {
        return OpenShiftHandlers.getOperation(BrokerTemplateInstance.class, BrokerTemplateInstanceList.class, this.httpClient, this.getConfiguration());
    }

    public MixedOperation<User, UserList, Resource<User>> users() {
        return new UserOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<ClusterRoleBinding, ClusterRoleBindingList, Resource<ClusterRoleBinding>> clusterRoleBindings() {
        return new ClusterRoleBindingOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<RoleBindingRestriction, RoleBindingRestrictionList, Resource<RoleBindingRestriction>> roleBindingRestrictions() {
        return OpenShiftHandlers.getOperation(RoleBindingRestriction.class, RoleBindingRestrictionList.class, this.httpClient, this.getConfiguration());
    }

    public NamespacedOpenShiftClient inNamespace(String namespace) {
        OpenShiftConfig updated = ((OpenShiftConfigBuilder)new OpenShiftConfigBuilder(this.getConfiguration()).withNamespace(namespace)).build();
        return new DefaultOpenShiftClient(this.httpClient, updated);
    }

    public NamespacedOpenShiftClient inAnyNamespace() {
        return this.inNamespace(null);
    }

    public ExtensionsAPIGroupClient extensions() {
        return (ExtensionsAPIGroupClient)this.adapt(ExtensionsAPIGroupClient.class);
    }

    @Override
    public VersionInfo getVersion() {
        for (Supplier supplier : new Supplier[]{this::getOpenShiftV3Version, this::getOpenShiftV4VersionInfo}) {
            try {
                VersionInfo vi = (VersionInfo)supplier.get();
                if (vi == null) continue;
                return vi;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.getVersion();
    }

    public VersionInfo getKubernetesVersion() {
        return super.getVersion();
    }

    @Override
    public VersionInfo getOpenShiftV3Version() {
        return this.getVersionInfo(OPENSHIFT_VERSION_ENDPOINT);
    }

    private VersionInfo getOpenShiftV4VersionInfo() {
        return ((KubernetesResourceList)this.resources(ClusterVersion.class).list()).getItems().stream().findFirst().map(clusterVersion -> {
            String[] versionParts = clusterVersion.getStatus().getDesired().getVersion().split("\\.");
            VersionInfo.Builder versionInfoBuilder = new VersionInfo.Builder();
            if (versionParts.length > 2) {
                versionInfoBuilder.withMajor(versionParts[0]);
                versionInfoBuilder.withMinor(versionParts[1] + "." + versionParts[2]);
            }
            try {
                versionInfoBuilder.withBuildDate(clusterVersion.getMetadata().getCreationTimestamp());
            }
            catch (ParseException e) {
                return null;
            }
            return versionInfoBuilder.build();
        }).orElse(null);
    }

    @Override
    public String getOpenShiftV4Version() {
        return ((KubernetesResourceList)this.resources(ClusterVersion.class).list()).getItems().stream().findFirst().map(cv -> cv.getStatus().getDesired().getVersion()).orElse(null);
    }

    @Override
    public MachineConfigurationAPIGroupDSL machineConfigurations() {
        return (MachineConfigurationAPIGroupDSL)this.adapt(OpenShiftMachineConfigurationAPIGroupClient.class);
    }

    @Override
    public OpenShiftMachineAPIGroupDSL machine() {
        return (OpenShiftMachineAPIGroupDSL)this.adapt(OpenShiftMachineAPIGroupClient.class);
    }

    @Override
    public OpenShiftMonitoringAPIGroupDSL monitoring() {
        return (OpenShiftMonitoringAPIGroupDSL)this.adapt(OpenShiftMonitoringAPIGroupClient.class);
    }

    @Override
    public NonNamespaceOperation<NetNamespace, NetNamespaceList, Resource<NetNamespace>> netNamespaces() {
        return OpenShiftHandlers.getOperation(NetNamespace.class, NetNamespaceList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<ClusterNetwork, ClusterNetworkList, Resource<ClusterNetwork>> clusterNetworks() {
        return OpenShiftHandlers.getOperation(ClusterNetwork.class, ClusterNetworkList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<EgressNetworkPolicy, EgressNetworkPolicyList, Resource<EgressNetworkPolicy>> egressNetworkPolicies() {
        return OpenShiftHandlers.getOperation(EgressNetworkPolicy.class, EgressNetworkPolicyList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<HostSubnet, HostSubnetList, Resource<HostSubnet>> hostSubnets() {
        return OpenShiftHandlers.getOperation(HostSubnet.class, HostSubnetList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<BareMetalHost, BareMetalHostList, Resource<BareMetalHost>> bareMetalHosts() {
        return OpenShiftHandlers.getOperation(BareMetalHost.class, BareMetalHostList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public InOutCreateable<SubjectAccessReview, SubjectAccessReviewResponse> subjectAccessReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(SubjectAccessReview.class, SubjectAccessReviewResponse.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public InOutCreateable<ResourceAccessReview, ResourceAccessReviewResponse> resourceAccessReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(ResourceAccessReview.class, ResourceAccessReviewResponse.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NamespacedInOutCreateable<LocalSubjectAccessReview, SubjectAccessReviewResponse> localSubjectAccessReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(LocalSubjectAccessReview.class, SubjectAccessReviewResponse.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NamespacedInOutCreateable<LocalResourceAccessReview, ResourceAccessReviewResponse> localResourceAccessReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(LocalResourceAccessReview.class, ResourceAccessReviewResponse.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NamespacedInOutCreateable<SelfSubjectRulesReview, SelfSubjectRulesReview> selfSubjectRulesReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(SelfSubjectRulesReview.class, SelfSubjectRulesReview.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NamespacedInOutCreateable<SubjectRulesReview, SubjectRulesReview> subjectRulesReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(SubjectRulesReview.class, SubjectRulesReview.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public OpenShiftStorageVersionMigratorApiGroupDSL kubeStorageVersionMigrator() {
        return (OpenShiftStorageVersionMigratorApiGroupDSL)this.adapt(OpenShiftStorageVersionMigratorApiGroupClient.class);
    }

    @Override
    public NonNamespaceOperation<ClusterRole, ClusterRoleList, Resource<ClusterRole>> clusterRoles() {
        return OpenShiftHandlers.getOperation(ClusterRole.class, ClusterRoleList.class, this.httpClient, this.getConfiguration());
    }

    public LeaderElectorBuilder<NamespacedOpenShiftClient> leaderElector() {
        return new LeaderElectorBuilder((Namespaceable)this);
    }

    @Override
    public FunctionCallable<NamespacedOpenShiftClient> withRequestConfig(RequestConfig requestConfig) {
        return new WithRequestCallable((Client)this, requestConfig);
    }

    @Override
    public User currentUser() {
        return (User)((Resource)this.users().withName("~")).get();
    }

    @Override
    public NonNamespaceOperation<Identity, IdentityList, Resource<Identity>> identities() {
        return OpenShiftHandlers.getOperation(Identity.class, IdentityList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public InOutCreateable<UserIdentityMapping, UserIdentityMapping> userIdentityMappings() {
        return Handlers.getNonListingOperation(UserIdentityMapping.class, (OkHttpClient)this.httpClient, (io.fabric8.kubernetes.client.Config)this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<UserOAuthAccessToken, UserOAuthAccessTokenList, Resource<UserOAuthAccessToken>> userOAuthAccessTokens() {
        return OpenShiftHandlers.getOperation(UserOAuthAccessToken.class, UserOAuthAccessTokenList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public OpenShiftWhereaboutsAPIGroupDSL whereabouts() {
        return (OpenShiftWhereaboutsAPIGroupDSL)this.adapt(OpenShiftWhereaboutsAPIGroupClient.class);
    }

    @Override
    public boolean supportsOpenShiftAPIGroup(String apiGroup) {
        List paths;
        String apiGroupPath = "/apis/" + apiGroup;
        RootPaths rootPaths = this.rootPaths();
        if (rootPaths != null && (paths = rootPaths.getPaths()) != null) {
            for (String path : paths) {
                if (!Objects.equals("/oapi", path) && !Objects.equals("oapi", path) && !Objects.equals(apiGroupPath, path)) continue;
                return true;
            }
        }
        return false;
    }

    protected OkHttpClient adaptOkHttpClient(OkHttpClient okHttpClient) {
        return OpenshiftAdapterSupport.adaptOkHttpClient(okHttpClient, this.getConfiguration());
    }
}

