/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitor;
import io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.ServiceMonitorOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class ServiceMonitorHandler
implements ResourceHandler<ServiceMonitor, ServiceMonitorBuilder> {
    public String getKind() {
        return ServiceMonitor.class.getSimpleName();
    }

    public String getApiVersion() {
        return "monitoring.coreos.com/v1";
    }

    public ServiceMonitor create(OkHttpClient client, Config config, String namespace, ServiceMonitor item) {
        return (ServiceMonitor)new ServiceMonitorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).create((Object[])new ServiceMonitor[0]);
    }

    public ServiceMonitor replace(OkHttpClient client, Config config, String namespace, ServiceMonitor item) {
        return (ServiceMonitor)((Resource)new ServiceMonitorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).replace((Object)item);
    }

    public ServiceMonitor reload(OkHttpClient client, Config config, String namespace, ServiceMonitor item) {
        return (ServiceMonitor)((Gettable)((Resource)new ServiceMonitorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public ServiceMonitorBuilder edit(ServiceMonitor item) {
        return new ServiceMonitorBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, ServiceMonitor item) {
        return new ServiceMonitorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).withPropagationPolicy(propagationPolicy).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ServiceMonitor item, Watcher<ServiceMonitor> watcher) {
        return ((Resource)new ServiceMonitorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ServiceMonitor item, String resourceVersion, Watcher<ServiceMonitor> watcher) {
        return ((Resource)new ServiceMonitorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ServiceMonitor item, ListOptions options, Watcher<ServiceMonitor> watcher) {
        return ((Resource)new ServiceMonitorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public ServiceMonitor waitUntilReady(OkHttpClient client, Config config, String namespace, ServiceMonitor item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ServiceMonitor)((Resource)new ServiceMonitorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public ServiceMonitor waitUntilCondition(OkHttpClient client, Config config, String namespace, ServiceMonitor item, Predicate<ServiceMonitor> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ServiceMonitor)((Resource)new ServiceMonitorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

