/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.OpenShiftConfigBuilder;
import io.fabric8.openshift.client.internal.readiness.OpenShiftReadiness;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class OpenShiftOperation<T extends HasMetadata, L extends KubernetesResourceList<T>, R extends Resource<T>>
extends HasMetadataOperation<T, L, R> {
    public static final String OPENSHIFT_APIGROUP_SUFFIX = "openshift.io";

    public OpenShiftOperation(OperationContext ctx) {
        super(OpenShiftOperation.wrap(ctx));
        this.updateApiVersion();
    }

    static OperationContext wrap(OperationContext context) {
        OpenShiftConfig config = OpenShiftConfig.wrap(context.getConfig());
        String oapiVersion = config.getOapiVersion();
        if (Utils.isNotNullOrEmpty((String)context.getApiGroupName())) {
            return OpenShiftOperation.getOperationContextWithApiGroupName(config, context, oapiVersion);
        }
        String apiGroupUrl = URLUtils.join((String[])new String[]{config.getMasterUrl(), "oapi", oapiVersion});
        return context.withConfig((Config)((OpenShiftConfigBuilder)new OpenShiftConfigBuilder(config).withOpenShiftUrl(apiGroupUrl)).build()).withApiGroupVersion(oapiVersion);
    }

    static OperationContext getOperationContextWithApiGroupName(OpenShiftConfig config, OperationContext context, String oapiVersion) {
        String apiGroupVersionFromConfig;
        String string = apiGroupVersionFromConfig = Utils.isNotNullOrEmpty((String)context.getApiGroupVersion()) ? context.getApiGroupVersion() : oapiVersion;
        if (OpenShiftOperation.isOpenShiftApiGroup(context.getApiGroupName())) {
            return OpenShiftOperation.getOpenShiftOperationContext(config, context, apiGroupVersionFromConfig);
        }
        return OpenShiftOperation.getOperationContextWithApiGroupVersion(config, context, apiGroupVersionFromConfig);
    }

    private static OperationContext getOpenShiftOperationContext(OpenShiftConfig config, OperationContext context, String oapiVersion) {
        if (config.isOpenshiftApiGroupsEnabled()) {
            return OpenShiftOperation.getOperationContextWithApiGroupVersion(config, context, oapiVersion);
        }
        String apiGroupUrl = URLUtils.join((String[])new String[]{config.getMasterUrl(), "oapi", oapiVersion});
        return context.withConfig((Config)((OpenShiftConfigBuilder)new OpenShiftConfigBuilder(config).withOpenShiftUrl(apiGroupUrl)).build()).withApiGroupName(context.getApiGroupName()).withApiGroupVersion(oapiVersion);
    }

    private static OperationContext getOperationContextWithApiGroupVersion(OpenShiftConfig config, OperationContext context, String version) {
        String apiGroupUrl = URLUtils.join((String[])new String[]{config.getMasterUrl(), "apis", context.getApiGroupName(), version});
        String apiGroupVersion = URLUtils.join((String[])new String[]{context.getApiGroupName(), version});
        return context.withConfig((Config)((OpenShiftConfigBuilder)new OpenShiftConfigBuilder(config).withOpenShiftUrl(apiGroupUrl)).build()).withApiGroupName(context.getApiGroupName()).withApiGroupVersion(apiGroupVersion);
    }

    private static boolean isOpenShiftApiGroup(String apiGroupName) {
        return apiGroupName.contains(OPENSHIFT_APIGROUP_SUFFIX);
    }

    public OpenShiftConfig getConfig() {
        return OpenShiftConfig.wrap(super.getConfig());
    }

    public URL getRootUrl() {
        if (Utils.isNullOrEmpty((String)this.context.getApiGroupName())) {
            try {
                return new URL(OpenShiftConfig.wrap(this.getConfig()).getOpenShiftUrl());
            }
            catch (MalformedURLException e) {
                throw KubernetesClientException.launderThrowable((Throwable)e);
            }
        }
        return super.getRootUrl();
    }

    public Boolean isReady() {
        return OpenShiftReadiness.isReady(this.get());
    }

    public T waitUntilReady(long amount, TimeUnit timeUnit) throws InterruptedException {
        return (T)this.waitUntilCondition(resource -> Objects.nonNull(resource) && OpenShiftReadiness.isReady(resource), amount, timeUnit);
    }

    private void updateApiVersion() {
        if (this.apiGroupName != null && this.apiGroupVersion != null) {
            this.apiVersion = this.apiGroupName + "/" + this.apiGroupVersion;
        } else if (this.apiGroupVersion != null) {
            this.apiVersion = this.apiGroupVersion;
        }
    }

    protected Class<? extends Config> getConfigType() {
        return OpenShiftConfig.class;
    }
}

