/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.CatalogSource;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.CatalogSourceBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.CatalogSourceOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class CatalogSourceHandler
implements ResourceHandler<CatalogSource, CatalogSourceBuilder> {
    public String getKind() {
        return CatalogSource.class.getSimpleName();
    }

    public String getApiVersion() {
        return "operators.coreos.com/v1alpha1";
    }

    public CatalogSource create(OkHttpClient client, Config config, String namespace, CatalogSource item) {
        return (CatalogSource)new CatalogSourceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).create((Object[])new CatalogSource[0]);
    }

    public CatalogSource replace(OkHttpClient client, Config config, String namespace, CatalogSource item) {
        return (CatalogSource)((Resource)new CatalogSourceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).replace((Object)item);
    }

    public CatalogSource reload(OkHttpClient client, Config config, String namespace, CatalogSource item) {
        return (CatalogSource)((Gettable)((Resource)new CatalogSourceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public CatalogSourceBuilder edit(CatalogSource item) {
        return new CatalogSourceBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, CatalogSource item) {
        return new CatalogSourceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).withPropagationPolicy(propagationPolicy).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, CatalogSource item, Watcher<CatalogSource> watcher) {
        return ((Resource)new CatalogSourceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, CatalogSource item, String resourceVersion, Watcher<CatalogSource> watcher) {
        return ((Resource)new CatalogSourceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, CatalogSource item, ListOptions options, Watcher<CatalogSource> watcher) {
        return ((Resource)new CatalogSourceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public CatalogSource waitUntilReady(OkHttpClient client, Config config, String namespace, CatalogSource item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (CatalogSource)((Resource)new CatalogSourceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public CatalogSource waitUntilCondition(OkHttpClient client, Config config, String namespace, CatalogSource item, Predicate<CatalogSource> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (CatalogSource)((Resource)new CatalogSourceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

