/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.ClusterNetwork;
import io.fabric8.openshift.api.model.ClusterNetworkBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.ClusterNetworkOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class ClusterNetworkHandler
implements ResourceHandler<ClusterNetwork, ClusterNetworkBuilder> {
    public String getKind() {
        return ClusterNetwork.class.getSimpleName();
    }

    public String getApiVersion() {
        return "network.openshift.io/v1";
    }

    public ClusterNetwork create(OkHttpClient client, Config config, String namespace, ClusterNetwork item) {
        return (ClusterNetwork)new ClusterNetworkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).create((Object[])new ClusterNetwork[0]);
    }

    public ClusterNetwork replace(OkHttpClient client, Config config, String namespace, ClusterNetwork item) {
        return (ClusterNetwork)((Resource)new ClusterNetworkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).replace((Object)item);
    }

    public ClusterNetwork reload(OkHttpClient client, Config config, String namespace, ClusterNetwork item) {
        return (ClusterNetwork)((Gettable)((Resource)new ClusterNetworkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public ClusterNetworkBuilder edit(ClusterNetwork item) {
        return new ClusterNetworkBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, ClusterNetwork item) {
        return (Boolean)new ClusterNetworkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).withPropagationPolicy(propagationPolicy).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ClusterNetwork item, Watcher<ClusterNetwork> watcher) {
        return (Watch)((Resource)new ClusterNetworkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ClusterNetwork item, String resourceVersion, Watcher<ClusterNetwork> watcher) {
        return (Watch)((Resource)new ClusterNetworkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ClusterNetwork item, ListOptions options, Watcher<ClusterNetwork> watcher) {
        return (Watch)((Resource)new ClusterNetworkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public ClusterNetwork waitUntilReady(OkHttpClient client, Config config, String namespace, ClusterNetwork item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ClusterNetwork)((Resource)new ClusterNetworkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public ClusterNetwork waitUntilCondition(OkHttpClient client, Config config, String namespace, ClusterNetwork item, Predicate<ClusterNetwork> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ClusterNetwork)((Resource)new ClusterNetworkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

