/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.DoneableOpenshiftRoleBinding;
import io.fabric8.openshift.api.model.OpenshiftRoleBinding;
import io.fabric8.openshift.api.model.OpenshiftRoleBindingBuilder;
import io.fabric8.openshift.api.model.OpenshiftRoleBindingFluent;
import io.fabric8.openshift.api.model.OpenshiftRoleBindingList;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import okhttp3.OkHttpClient;

public class OpenshiftRoleBindingOperationsImpl
extends OpenShiftOperation<OpenshiftRoleBinding, OpenshiftRoleBindingList, DoneableOpenshiftRoleBinding, Resource<OpenshiftRoleBinding, DoneableOpenshiftRoleBinding>> {
    public OpenshiftRoleBindingOperationsImpl(OkHttpClient client, OpenShiftConfig config, String namespace) {
        this(client, config, "authorization.openshift.io", null, namespace, null, true, null, null, false, -1L, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>());
    }

    public OpenshiftRoleBindingOperationsImpl(OkHttpClient client, OpenShiftConfig config, String apiGroup, String apiVersion, String namespace, String name, Boolean cascading, OpenshiftRoleBinding item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
        super(client, OpenShiftOperation.withApiGroup(client, apiGroup, apiVersion, config), "rolebindings", namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields);
    }

    public OpenshiftRoleBinding replace(OpenshiftRoleBinding item) {
        OpenshiftRoleBinding enriched = this.enrichRoleBinding(item);
        return (OpenshiftRoleBinding)super.replace((HasMetadata)enriched);
    }

    public OpenshiftRoleBinding patch(OpenshiftRoleBinding item) {
        OpenshiftRoleBinding enriched = this.enrichRoleBinding(item);
        return (OpenshiftRoleBinding)super.patch((HasMetadata)enriched);
    }

    protected OpenshiftRoleBinding handleCreate(OpenshiftRoleBinding resource) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        return (OpenshiftRoleBinding)super.handleCreate((Object)this.enrichRoleBinding(resource));
    }

    private OpenshiftRoleBinding enrichRoleBinding(OpenshiftRoleBinding binding) {
        OpenshiftRoleBindingBuilder builder = new OpenshiftRoleBindingBuilder(binding);
        if (binding.getUserNames() != null && !binding.getUserNames().isEmpty() || binding.getGroupNames() != null && !binding.getGroupNames().isEmpty()) {
            this.enrichFromUsersAndGroups(builder, binding.getUserNames(), binding.getGroupNames());
        } else {
            this.enrichFromSubjects(builder, binding.getSubjects());
            this.enrichSubjectsNamespace(builder);
        }
        return builder.build();
    }

    private void enrichSubjectsNamespace(OpenshiftRoleBindingBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<ObjectReferenceBuilder>(){

            public void visit(ObjectReferenceBuilder o) {
                if (o.getKind() != null && o.getKind().equals("ServiceAccount") && (o.getNamespace() == null || o.getNamespace().isEmpty())) {
                    o.withNamespace(OpenshiftRoleBindingOperationsImpl.this.getNamespace());
                }
            }
        });
    }

    private void enrichFromUsersAndGroups(OpenshiftRoleBindingBuilder builder, List<String> userNames, List<String> groupNames) {
        builder.withSubjects(new ObjectReference[0]);
        if (userNames != null) {
            for (String userName : userNames) {
                String[] splitUserName;
                if (userName.startsWith("system:serviceaccount:") && (splitUserName = userName.split(":")).length == 4) {
                    ((OpenshiftRoleBindingFluent.SubjectsNested)((OpenshiftRoleBindingFluent.SubjectsNested)((OpenshiftRoleBindingFluent.SubjectsNested)builder.addNewSubject().withKind("ServiceAccount")).withNamespace(splitUserName[2])).withName(splitUserName[3])).endSubject();
                    continue;
                }
                ((OpenshiftRoleBindingFluent.SubjectsNested)((OpenshiftRoleBindingFluent.SubjectsNested)builder.addNewSubject().withKind("User")).withName(userName)).endSubject();
            }
        }
        if (groupNames != null) {
            for (String groupName : groupNames) {
                ((OpenshiftRoleBindingFluent.SubjectsNested)((OpenshiftRoleBindingFluent.SubjectsNested)builder.addNewSubject().withKind("Group")).withName(groupName)).endSubject();
            }
        }
    }

    private void enrichFromSubjects(OpenshiftRoleBindingBuilder builder, List<ObjectReference> subjects) {
        for (ObjectReference ref : subjects) {
            switch (ref.getKind()) {
                case "User": {
                    builder.addToUserNames(new String[]{ref.getName()});
                    break;
                }
                case "ServiceAccount": {
                    String namespace = ref.getNamespace();
                    if (namespace == null || namespace.isEmpty()) {
                        namespace = this.getNamespace();
                    }
                    builder.addToUserNames(new String[]{"system:serviceaccount:" + namespace + ":" + ref.getName()});
                    break;
                }
                case "Group": {
                    builder.addToGroupNames(new String[]{ref.getName()});
                }
            }
        }
    }
}

