/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.openshift.api.model.DoneableRoleBinding;
import io.fabric8.openshift.api.model.RoleBinding;
import io.fabric8.openshift.api.model.RoleBindingBuilder;
import io.fabric8.openshift.api.model.RoleBindingFluent;
import io.fabric8.openshift.api.model.RoleBindingList;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import okhttp3.OkHttpClient;

public class RoleBindingOperationsImpl
extends OpenShiftOperation<RoleBinding, RoleBindingList, DoneableRoleBinding, ClientResource<RoleBinding, DoneableRoleBinding>> {
    public RoleBindingOperationsImpl(OkHttpClient client, OpenShiftConfig config, String namespace) {
        this(client, config, null, namespace, null, true, null, null, false, -1L, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>());
    }

    public RoleBindingOperationsImpl(OkHttpClient client, OpenShiftConfig config, String apiVersion, String namespace, String name, Boolean cascading, RoleBinding item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
        super(client, config, null, apiVersion, "rolebindings", namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields);
    }

    public RoleBinding replace(RoleBinding item) {
        RoleBinding enriched = this.enrichRoleBinding(item);
        return (RoleBinding)super.replace((HasMetadata)enriched);
    }

    public RoleBinding patch(RoleBinding item) {
        RoleBinding enriched = this.enrichRoleBinding(item);
        return (RoleBinding)super.patch((HasMetadata)enriched);
    }

    public RoleBinding create(RoleBinding ... resources) throws KubernetesClientException {
        Object[] enriched = new RoleBinding[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            enriched[i] = this.enrichRoleBinding(resources[i]);
        }
        return (RoleBinding)super.create(enriched);
    }

    private RoleBinding enrichRoleBinding(RoleBinding binding) {
        RoleBindingBuilder builder = new RoleBindingBuilder(binding);
        if (binding.getUserNames() != null && !binding.getUserNames().isEmpty() || binding.getGroupNames() != null && !binding.getGroupNames().isEmpty()) {
            this.enrichFromUsersAndGroups(builder, binding.getUserNames(), binding.getGroupNames());
        } else {
            this.enrichFromSubjects(builder, binding.getSubjects());
            this.enrichSubjectsNamespace(builder);
        }
        return builder.build();
    }

    private void enrichSubjectsNamespace(RoleBindingBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<ObjectReferenceBuilder>(){

            public void visit(ObjectReferenceBuilder o) {
                if (o.getKind() != null && o.getKind().equals("ServiceAccount") && (o.getNamespace() == null || o.getNamespace().isEmpty())) {
                    o.withNamespace(RoleBindingOperationsImpl.this.getNamespace());
                }
            }
        });
    }

    private void enrichFromUsersAndGroups(RoleBindingBuilder builder, List<String> userNames, List<String> groupNames) {
        builder.withSubjects(new ObjectReference[0]);
        if (userNames != null) {
            for (String userName : userNames) {
                String[] splitUserName;
                if (userName.startsWith("system:serviceaccount:") && (splitUserName = userName.split(":")).length == 4) {
                    ((RoleBindingFluent.SubjectsNested)((RoleBindingFluent.SubjectsNested)((RoleBindingFluent.SubjectsNested)builder.addNewSubject().withKind("ServiceAccount")).withNamespace(splitUserName[2])).withName(splitUserName[3])).endSubject();
                    continue;
                }
                ((RoleBindingFluent.SubjectsNested)((RoleBindingFluent.SubjectsNested)builder.addNewSubject().withKind("User")).withName(userName)).endSubject();
            }
        }
        if (groupNames != null) {
            for (String groupName : groupNames) {
                ((RoleBindingFluent.SubjectsNested)((RoleBindingFluent.SubjectsNested)builder.addNewSubject().withKind("Group")).withName(groupName)).endSubject();
            }
        }
    }

    private void enrichFromSubjects(RoleBindingBuilder builder, List<ObjectReference> subjects) {
        for (ObjectReference ref : subjects) {
            switch (ref.getKind()) {
                case "User": {
                    builder.addToUserNames(new String[]{ref.getName()});
                    break;
                }
                case "ServiceAccount": {
                    String namespace = ref.getNamespace();
                    if (namespace == null || namespace.isEmpty()) {
                        namespace = this.getNamespace();
                    }
                    builder.addToUserNames(new String[]{"system:serviceaccount:" + namespace + ":" + ref.getName()});
                    break;
                }
                case "Group": {
                    builder.addToGroupNames(new String[]{ref.getName()});
                }
            }
        }
    }
}

