/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.osgi;

import io.fabric8.kubernetes.api.model.ComponentStatus;
import io.fabric8.kubernetes.api.model.ComponentStatusList;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.api.model.DoneableComponentStatus;
import io.fabric8.kubernetes.api.model.DoneableConfigMap;
import io.fabric8.kubernetes.api.model.DoneableEndpoints;
import io.fabric8.kubernetes.api.model.DoneableEvent;
import io.fabric8.kubernetes.api.model.DoneableNamespace;
import io.fabric8.kubernetes.api.model.DoneableNode;
import io.fabric8.kubernetes.api.model.DoneablePersistentVolume;
import io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.DoneableReplicationController;
import io.fabric8.kubernetes.api.model.DoneableResourceQuota;
import io.fabric8.kubernetes.api.model.DoneableSecret;
import io.fabric8.kubernetes.api.model.DoneableSecurityContextConstraints;
import io.fabric8.kubernetes.api.model.DoneableService;
import io.fabric8.kubernetes.api.model.DoneableServiceAccount;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsList;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.EventList;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceList;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.NodeList;
import io.fabric8.kubernetes.api.model.PersistentVolume;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.PersistentVolumeList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.ResourceQuotaList;
import io.fabric8.kubernetes.api.model.RootPaths;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.api.model.SecurityContextConstraints;
import io.fabric8.kubernetes.api.model.SecurityContextConstraintsList;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountList;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.client.BaseClient;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.ClientKubernetesListMixedOperation;
import io.fabric8.kubernetes.client.dsl.ClientMixedOperation;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientPodResource;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.ClientRollableScallableResource;
import io.fabric8.kubernetes.client.dsl.ExtensionsAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.NamespaceVisitFromServerGetDeleteRecreateApplicable;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.ClusterRoleBinding;
import io.fabric8.openshift.api.model.ClusterRoleBindingList;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigList;
import io.fabric8.openshift.api.model.DoneableBuild;
import io.fabric8.openshift.api.model.DoneableBuildConfig;
import io.fabric8.openshift.api.model.DoneableClusterRoleBinding;
import io.fabric8.openshift.api.model.DoneableDeploymentConfig;
import io.fabric8.openshift.api.model.DoneableGroup;
import io.fabric8.openshift.api.model.DoneableImageStream;
import io.fabric8.openshift.api.model.DoneableOAuthAccessToken;
import io.fabric8.openshift.api.model.DoneableOAuthAuthorizeToken;
import io.fabric8.openshift.api.model.DoneableOAuthClient;
import io.fabric8.openshift.api.model.DoneablePolicy;
import io.fabric8.openshift.api.model.DoneablePolicyBinding;
import io.fabric8.openshift.api.model.DoneableProject;
import io.fabric8.openshift.api.model.DoneableRoleBinding;
import io.fabric8.openshift.api.model.DoneableRoute;
import io.fabric8.openshift.api.model.DoneableTemplate;
import io.fabric8.openshift.api.model.DoneableUser;
import io.fabric8.openshift.api.model.Group;
import io.fabric8.openshift.api.model.GroupList;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamList;
import io.fabric8.openshift.api.model.OAuthAccessToken;
import io.fabric8.openshift.api.model.OAuthAccessTokenList;
import io.fabric8.openshift.api.model.OAuthAuthorizeToken;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenList;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.OAuthClientList;
import io.fabric8.openshift.api.model.Policy;
import io.fabric8.openshift.api.model.PolicyBinding;
import io.fabric8.openshift.api.model.PolicyBindingList;
import io.fabric8.openshift.api.model.PolicyList;
import io.fabric8.openshift.api.model.Project;
import io.fabric8.openshift.api.model.ProjectList;
import io.fabric8.openshift.api.model.RoleBinding;
import io.fabric8.openshift.api.model.RoleBindingList;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteList;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.api.model.TemplateList;
import io.fabric8.openshift.api.model.User;
import io.fabric8.openshift.api.model.UserList;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.NamespacedOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.OpenShiftConfigBuilder;
import io.fabric8.openshift.client.dsl.ClientBuildConfigResource;
import io.fabric8.openshift.client.dsl.ClientProjectRequestOperation;
import io.fabric8.openshift.client.dsl.ClientSubjectAccessReviewOperation;
import io.fabric8.openshift.client.dsl.ClientTemplateResource;
import io.fabric8.openshift.client.dsl.CreateableLocalSubjectAccessReview;
import io.fabric8.openshift.client.dsl.CreateableSubjectAccessReview;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;

@Component(immediate=true, configurationPid="io.fabric8.openshift.client", policy=ConfigurationPolicy.OPTIONAL)
@Service(value={OpenShiftClient.class, NamespacedOpenShiftClient.class})
public class ManagedOpenShiftClient
extends BaseClient
implements NamespacedOpenShiftClient {
    @Property(name="openshift.url")
    private String openshiftUrl = Utils.getSystemPropertyOrEnvVar((String)"openshift.url");
    @Property(name="kubernetes.oapi.version", value={"v1"})
    private String oapiVersion = Utils.getSystemPropertyOrEnvVar((String)"kubernetes.oapi.version");
    @Property(name="kubernetes.master", description="Master URL", value={"https://kubernetes.default.svc"})
    private String masterUrl = Utils.getSystemPropertyOrEnvVar((String)"kubernetes.master", (String)"https://kubernetes.default.svc");
    @Property(name="kubernetes.api.version", description="Api Version", value={"v1"})
    private String apiVersion = Utils.getSystemPropertyOrEnvVar((String)"kubernetes.api.version", (String)"v1");
    @Property(name="kubernetes.namespace", description="Default namespace", value={"default"})
    private String namespace = Utils.getSystemPropertyOrEnvVar((String)"kubernetes.namespace", (String)"default");
    @Property(name="kubernetes.certs.ca.file", description="CA Certificate (Path to file)")
    private String caCertFile = Utils.getSystemPropertyOrEnvVar((String)"kubernetes.certs.ca.file");
    @Property(name="kubernetes.certs.ca.data", description="CA Certificate (Data)")
    private String caCertData = Utils.getSystemPropertyOrEnvVar((String)"kubernetes.certs.ca.data");
    @Property(name="kubernetes.certs.client.file", description="Client Certificate (Path to file)")
    private String clientCertFile = Utils.getSystemPropertyOrEnvVar((String)"kubernetes.certs.client.file");
    @Property(name="kubernetes.certs.client.data", description="Client Certificate (Data)")
    private String clientCertData = Utils.getSystemPropertyOrEnvVar((String)"kubernetes.certs.client.data");
    @Property(name="kubernetes.certs.client.key.file", description="Client Key (Path to file)")
    private String clientKeyFile = Utils.getSystemPropertyOrEnvVar((String)"kubernetes.certs.client.key.file");
    @Property(name="kubernetes.certs.client.key.data", description="Client Key (Data)")
    private String clientKeyData = Utils.getSystemPropertyOrEnvVar((String)"kubernetes.certs.client.key.data");
    @Property(name="kubernetes.certs.client.key.algo", description="Client Key Algorithm")
    private String clientKeyAlgo = Utils.getSystemPropertyOrEnvVar((String)"kubernetes.certs.client.key.algo", (String)"RSA");
    @Property(name="kubernetes.certs.client.key.passphrase", description="Client passphrase")
    private String clientKeyPassphrase = Utils.getSystemPropertyOrEnvVar((String)"kubernetes.certs.client.key.passphrase", (String)"changeit");
    @Property(name="kubernetes.auth.basic.username", description="Username")
    private String username = Utils.getSystemPropertyOrEnvVar((String)"kubernetes.auth.basic.username");
    @Property(name="kubernetes.auth.basic.password", description="Username")
    private String password = Utils.getSystemPropertyOrEnvVar((String)"kubernetes.auth.basic.password");
    @Property(name="kubernetes.auth.token", description="OAuth Token")
    private String oauthToken = Utils.getSystemPropertyOrEnvVar((String)"kubernetes.auth.token");
    @Property(name="kubernetes.watch.reconnectInterval", description="Watch reconnect interval", intValue={1000})
    private int watchReconnectInterval = Integer.parseInt(Utils.getSystemPropertyOrEnvVar((String)"kubernetes.watch.reconnectInterval", (String)"1000"));
    @Property(name="kubernetes.watch.reconnectLimit", description="Watch reconnect limit", intValue={-1})
    private int watchReconnectLimit = Integer.parseInt(Utils.getSystemPropertyOrEnvVar((String)"kubernetes.watch.reconnectLimit", (String)"-1"));
    @Property(name="kubernetes.request.timeout", description="Request timeout", intValue={10000})
    private int requestTimeout = Integer.parseInt(Utils.getSystemPropertyOrEnvVar((String)"kubernetes.request.timeout", (String)"10000"));
    @Property(name="http.proxy", description="HTTP Proxy")
    private String httpProxy = Utils.getSystemPropertyOrEnvVar((String)"http.proxy");
    @Property(name="https.proxy", description="HTTPS Proxy")
    private String httpsProxy = Utils.getSystemPropertyOrEnvVar((String)"https.proxy");
    @Property(name="all.proxy", description="All Proxy")
    private String allProxy = Utils.getSystemPropertyOrEnvVar((String)"all.proxy");
    @Property(name="no.proxy", description="No Proxy")
    private String noProxy = Utils.getSystemPropertyOrEnvVar((String)"no.proxy");
    @Property(name="kubernetes.trust.certificates", description="Kubernetes trust certifacates flag", boolValue={false})
    private Boolean trustCerts = Utils.getSystemPropertyOrEnvVar((String)"kubernetes.trust.certificates", (Boolean)Boolean.FALSE);
    private DefaultOpenShiftClient delegate;

    @Activate
    public void activate(Map<String, Object> properties) {
        String masterUrl = (String)properties.get("kubernetes.master");
        String openshiftUrl = (String)properties.get("openshift.url");
        String oapiVersion = (String)properties.get("openshift.url");
        String noProxyProperty = (String)properties.get("no.proxy");
        String[] noProxy = noProxyProperty != null ? noProxyProperty.split(",") : null;
        OpenShiftConfig config = ((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)new OpenShiftConfigBuilder().withMasterUrl(masterUrl)).withApiVersion((String)properties.get("kubernetes.api.version"))).withNamespace((String)properties.get("kubernetes.namespace"))).withCaCertFile((String)properties.get("kubernetes.certs.ca.file"))).withCaCertData((String)properties.get("kubernetes.certs.ca.data"))).withClientCertFile((String)properties.get("kubernetes.certs.client.file"))).withClientCertData((String)properties.get("kubernetes.certs.client.data"))).withClientKeyFile((String)properties.get("kubernetes.certs.client.key.file"))).withClientKeyData((String)properties.get("kubernetes.certs.client.key.data"))).withClientKeyAlgo((String)properties.get("kubernetes.certs.client.key.algo"))).withClientKeyPassphrase((String)properties.get("kubernetes.certs.client.key.passphrase"))).withUsername((String)properties.get("kubernetes.auth.basic.username"))).withPassword((String)properties.get("kubernetes.auth.basic.password"))).withOauthToken((String)properties.get("kubernetes.auth.token"))).withWatchReconnectInterval((Integer)properties.get("kubernetes.watch.reconnectInterval"))).withWatchReconnectLimit((Integer)properties.get("kubernetes.watch.reconnectLimit"))).withRequestTimeout((Integer)properties.get("kubernetes.request.timeout"))).withHttpProxy((String)properties.get("http.proxy"))).withHttpsProxy((String)properties.get("https.proxy"))).withNoProxy(noProxy)).withOpenShiftUrl(openshiftUrl != null && !openshiftUrl.isEmpty() ? openshiftUrl : URLUtils.join((String[])new String[]{masterUrl, "oapi", oapiVersion}))).build();
        this.delegate = new DefaultOpenShiftClient(config);
    }

    @Deactivate
    public void deactivate() {
        this.delegate.close();
    }

    @Override
    public URL getOpenshiftUrl() {
        return this.delegate.getOpenshiftUrl();
    }

    @Override
    public ClientMixedOperation<Build, BuildList, DoneableBuild, ClientResource<Build, DoneableBuild>> builds() {
        return this.delegate.builds();
    }

    public ClientMixedOperation<ComponentStatus, ComponentStatusList, DoneableComponentStatus, ClientResource<ComponentStatus, DoneableComponentStatus>> componentstatuses() {
        return this.delegate.componentstatuses();
    }

    @Override
    public ClientMixedOperation<BuildConfig, BuildConfigList, DoneableBuildConfig, ClientBuildConfigResource<BuildConfig, DoneableBuildConfig, Void, Build>> buildConfigs() {
        return this.delegate.buildConfigs();
    }

    @Override
    public ClientMixedOperation<DeploymentConfig, DeploymentConfigList, DoneableDeploymentConfig, ClientResource<DeploymentConfig, DoneableDeploymentConfig>> deploymentConfigs() {
        return this.delegate.deploymentConfigs();
    }

    @Override
    public ClientNonNamespaceOperation<Group, GroupList, DoneableGroup, ClientResource<Group, DoneableGroup>> groups() {
        return this.delegate.groups();
    }

    @Override
    public ClientMixedOperation<ImageStream, ImageStreamList, DoneableImageStream, ClientResource<ImageStream, DoneableImageStream>> imageStreams() {
        return this.delegate.imageStreams();
    }

    @Override
    public ClientNonNamespaceOperation<OAuthAccessToken, OAuthAccessTokenList, DoneableOAuthAccessToken, ClientResource<OAuthAccessToken, DoneableOAuthAccessToken>> oAuthAccessTokens() {
        return this.delegate.oAuthAccessTokens();
    }

    @Override
    public ClientNonNamespaceOperation<OAuthAuthorizeToken, OAuthAuthorizeTokenList, DoneableOAuthAuthorizeToken, ClientResource<OAuthAuthorizeToken, DoneableOAuthAuthorizeToken>> oAuthAuthorizeTokens() {
        return this.delegate.oAuthAuthorizeTokens();
    }

    @Override
    public ClientNonNamespaceOperation<OAuthClient, OAuthClientList, DoneableOAuthClient, ClientResource<OAuthClient, DoneableOAuthClient>> oAuthClients() {
        return this.delegate.oAuthClients();
    }

    @Override
    public ClientMixedOperation<Policy, PolicyList, DoneablePolicy, ClientResource<Policy, DoneablePolicy>> policies() {
        return this.delegate.policies();
    }

    @Override
    public ClientMixedOperation<PolicyBinding, PolicyBindingList, DoneablePolicyBinding, ClientResource<PolicyBinding, DoneablePolicyBinding>> policyBindings() {
        return this.delegate.policyBindings();
    }

    @Override
    public ClientNonNamespaceOperation<Project, ProjectList, DoneableProject, ClientResource<Project, DoneableProject>> projects() {
        return this.delegate.projects();
    }

    @Override
    public ClientProjectRequestOperation projectrequests() {
        return this.delegate.projectrequests();
    }

    @Override
    public ClientMixedOperation<RoleBinding, RoleBindingList, DoneableRoleBinding, ClientResource<RoleBinding, DoneableRoleBinding>> roleBindings() {
        return this.delegate.roleBindings();
    }

    @Override
    public ClientMixedOperation<Route, RouteList, DoneableRoute, ClientResource<Route, DoneableRoute>> routes() {
        return this.delegate.routes();
    }

    @Override
    public ClientMixedOperation<Template, TemplateList, DoneableTemplate, ClientTemplateResource<Template, KubernetesList, DoneableTemplate>> templates() {
        return this.delegate.templates();
    }

    @Override
    public ClientNonNamespaceOperation<User, UserList, DoneableUser, ClientResource<User, DoneableUser>> users() {
        return this.delegate.users();
    }

    @Override
    public ClientSubjectAccessReviewOperation<CreateableSubjectAccessReview, CreateableLocalSubjectAccessReview> subjectAccessReviews() {
        return this.delegate.subjectAccessReviews();
    }

    @Override
    public ClientMixedOperation<ClusterRoleBinding, ClusterRoleBindingList, DoneableClusterRoleBinding, ClientResource<ClusterRoleBinding, DoneableClusterRoleBinding>> clusterRoleBindings() {
        return this.delegate.clusterRoleBindings();
    }

    public NamespaceVisitFromServerGetDeleteRecreateApplicable<List<HasMetadata>, Boolean> load(InputStream is) {
        return this.delegate.load(is);
    }

    public ClientMixedOperation<Endpoints, EndpointsList, DoneableEndpoints, ClientResource<Endpoints, DoneableEndpoints>> endpoints() {
        return this.delegate.endpoints();
    }

    public ClientMixedOperation<Event, EventList, DoneableEvent, ClientResource<Event, DoneableEvent>> events() {
        return this.delegate.events();
    }

    public ClientNonNamespaceOperation<Namespace, NamespaceList, DoneableNamespace, ClientResource<Namespace, DoneableNamespace>> namespaces() {
        return this.delegate.namespaces();
    }

    public ClientNonNamespaceOperation<Node, NodeList, DoneableNode, ClientResource<Node, DoneableNode>> nodes() {
        return this.delegate.nodes();
    }

    public ClientNonNamespaceOperation<PersistentVolume, PersistentVolumeList, DoneablePersistentVolume, ClientResource<PersistentVolume, DoneablePersistentVolume>> persistentVolumes() {
        return this.delegate.persistentVolumes();
    }

    public ClientMixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, DoneablePersistentVolumeClaim, ClientResource<PersistentVolumeClaim, DoneablePersistentVolumeClaim>> persistentVolumeClaims() {
        return this.delegate.persistentVolumeClaims();
    }

    public ClientMixedOperation<Pod, PodList, DoneablePod, ClientPodResource<Pod, DoneablePod>> pods() {
        return this.delegate.pods();
    }

    public ClientMixedOperation<ReplicationController, ReplicationControllerList, DoneableReplicationController, ClientRollableScallableResource<ReplicationController, DoneableReplicationController>> replicationControllers() {
        return this.delegate.replicationControllers();
    }

    public ClientMixedOperation<ResourceQuota, ResourceQuotaList, DoneableResourceQuota, ClientResource<ResourceQuota, DoneableResourceQuota>> resourceQuotas() {
        return this.delegate.resourceQuotas();
    }

    public ClientMixedOperation<Secret, SecretList, DoneableSecret, ClientResource<Secret, DoneableSecret>> secrets() {
        return this.delegate.secrets();
    }

    public ClientMixedOperation<io.fabric8.kubernetes.api.model.Service, ServiceList, DoneableService, ClientResource<io.fabric8.kubernetes.api.model.Service, DoneableService>> services() {
        return this.delegate.services();
    }

    public ClientMixedOperation<ServiceAccount, ServiceAccountList, DoneableServiceAccount, ClientResource<ServiceAccount, DoneableServiceAccount>> serviceAccounts() {
        return this.delegate.serviceAccounts();
    }

    public ClientKubernetesListMixedOperation lists() {
        return this.delegate.lists();
    }

    public ClientNonNamespaceOperation<SecurityContextConstraints, SecurityContextConstraintsList, DoneableSecurityContextConstraints, ClientResource<SecurityContextConstraints, DoneableSecurityContextConstraints>> securityContextConstraints() {
        return this.delegate.securityContextConstraints();
    }

    public ClientMixedOperation<ConfigMap, ConfigMapList, DoneableConfigMap, ClientResource<ConfigMap, DoneableConfigMap>> configMaps() {
        return this.delegate.configMaps();
    }

    public <C> C adapt(Class<C> type) {
        return (C)this.delegate.adapt(type);
    }

    public URL getMasterUrl() {
        return this.delegate.getMasterUrl();
    }

    public String getApiVersion() {
        return this.delegate.getApiVersion();
    }

    public String getNamespace() {
        return this.delegate.getNamespace();
    }

    public RootPaths rootPaths() {
        return this.delegate.rootPaths();
    }

    public void close() {
        this.delegate.close();
    }

    public Config getConfiguration() {
        return this.delegate.getConfiguration();
    }

    @Override
    public ExtensionsAPIGroupDSL extensions() {
        return this.delegate.extensions();
    }

    public NamespacedOpenShiftClient inAnyNamespace() {
        return this.delegate.inAnyNamespace();
    }

    public NamespacedOpenShiftClient inNamespace(String name) {
        return this.delegate.inNamespace(name);
    }
}

