/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.BuildConfigClientResource;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Secretable;
import io.fabric8.kubernetes.client.dsl.Triggerable;
import io.fabric8.kubernetes.client.dsl.Typeable;
import io.fabric8.kubernetes.client.dsl.internal.BaseOperation;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.api.model.BuildRequest;
import io.fabric8.openshift.api.model.DoneableBuildConfig;
import io.fabric8.openshift.api.model.WebHookTrigger;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.OpenshiftOperation;
import java.net.URL;

public class BuildConfigOperationsImpl
extends OpenshiftOperation<OpenShiftClient, BuildConfig, BuildConfigList, DoneableBuildConfig, BuildConfigClientResource<BuildConfig, DoneableBuildConfig, Void, Void>>
implements BuildConfigClientResource<BuildConfig, DoneableBuildConfig, Void, Void>,
Typeable<Triggerable<WebHookTrigger, Void>>,
Triggerable<WebHookTrigger, Void>,
Secretable<Typeable<Triggerable<WebHookTrigger, Void>>> {
    private final String secret;
    private final String triggerType;

    public BuildConfigOperationsImpl(OpenShiftClient client, String secret, String triggerType) {
        super(client, "buildconfigs", null, null);
        this.triggerType = triggerType;
        this.secret = secret;
    }

    public BuildConfigOperationsImpl(OpenShiftClient client, String namespace, String name, String secret, String triggerType) {
        super(client, "buildconfigs", namespace, name);
        this.triggerType = triggerType;
        this.secret = secret;
    }

    public BuildConfigClientResource<BuildConfig, DoneableBuildConfig, Void, Void> withName(String name) {
        try {
            return (BuildConfigClientResource)((Object)((Object)this)).getClass().getConstructor(OpenShiftClient.class, String.class, String.class, String.class, String.class).newInstance(this.getClient(), this.getNamespace(), name, this.secret, this.triggerType);
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable((Throwable)t);
        }
    }

    public ClientNonNamespaceOperation<OpenShiftClient, BuildConfig, BuildConfigList, DoneableBuildConfig, BuildConfigClientResource<BuildConfig, DoneableBuildConfig, Void, Void>> inNamespace(String namespace) {
        try {
            return (ClientNonNamespaceOperation)((Object)((Object)this)).getClass().getConstructor(OpenShiftClient.class, String.class, String.class, String.class, String.class).newInstance(this.getClient(), namespace, this.getName(), this.secret, this.triggerType);
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable((Throwable)t);
        }
    }

    public Typeable<Triggerable<WebHookTrigger, Void>> withSecret(String secret) {
        return new BuildConfigOperationsImpl((OpenShiftClient)this.getClient(), this.getNamespace(), this.getName(), secret, this.triggerType);
    }

    public Void instantiate(BuildRequest request) {
        try {
            URL instantiationUrl = new URL(this.getResourceUrl().toString() + "/instantiate");
            AsyncHttpClient.BoundRequestBuilder requestBuilder = ((OpenShiftClient)this.getClient()).getHttpClient().preparePost(instantiationUrl.toString());
            requestBuilder.setBody(BaseOperation.mapper.writer().writeValueAsString((Object)request));
            this.handleResponse(requestBuilder, 201);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
        return null;
    }

    public Void trigger(WebHookTrigger trigger) {
        try {
            URL webhooksUrl = new URL(this.getResourceUrl().toString() + "/webhooks/");
            URL triggerUrl = new URL(webhooksUrl, this.secret + "/" + this.triggerType);
            AsyncHttpClient.BoundRequestBuilder requestBuilder = ((OpenShiftClient)this.getClient()).getHttpClient().preparePost(triggerUrl.toString());
            requestBuilder.addHeader("Content-Type", "application/json");
            requestBuilder.addHeader("X-Github-Event", "push");
            requestBuilder.setBody(BaseOperation.mapper.writer().writeValueAsString((Object)trigger));
            ListenableFuture f = requestBuilder.execute();
            Response r = (Response)f.get();
            if (r.getStatusCode() != 200) {
                Status status = (Status)BaseOperation.mapper.reader(Status.class).readValue(r.getResponseBodyAsStream());
                throw new KubernetesClientException(status.getMessage(), status.getCode().intValue(), status);
            }
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
        return null;
    }

    public Triggerable<WebHookTrigger, Void> withType(String type) {
        return new BuildConfigOperationsImpl((OpenShiftClient)this.getClient(), this.getNamespace(), this.getName(), this.secret, type);
    }
}

