/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.SundrioConfig;
import io.fabric8.kubernetes.client.readiness.Readiness;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.openshift.client.readiness.OpenShiftReadiness;
import java.net.MalformedURLException;
import java.net.URL;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true, allowGetters=true, allowSetters=true)
public class OpenShiftConfig
extends Config {
    public static final String KUBERNETES_OAPI_VERSION_SYSTEM_PROPERTY = "kubernetes.oapi.version";
    public static final String OPENSHIFT_URL_SYSTEM_PROPERTY = "openshift.url";
    public static final String OPENSHIFT_BUILD_TIMEOUT_SYSTEM_PROPERTY = "openshift.build.timeout";
    public static final String DISABLE_API_GROUP_CHECK = "disableApiGroupCheck";
    public static final String OPENSHIFT_URL = "openShiftUrl";
    public static final String BUILD_TIMEOUT = "buildTimeout";
    public static final String OAPI_VERSION = "oapiVersion";
    public static final Long DEFAULT_BUILD_TIMEOUT = 300000L;

    OpenShiftConfig() {
        super(!OpenShiftConfig.disableAutoConfig());
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public OpenShiftConfig(SundrioConfig config) {
        this(config, null, null, null, null);
    }

    public OpenShiftConfig(Config kubernetesConfig) {
        this((SundrioConfig)kubernetesConfig, null, null, null, null);
    }

    OpenShiftConfig(SundrioConfig kubernetesConfig, String openShiftUrl, String oapiVersion, Long buildTimeout, Boolean disableApiGroupCheck) {
        super(kubernetesConfig);
        if (oapiVersion == null) {
            oapiVersion = OpenShiftConfig.getDefaultOapiVersion(this.getApiVersion());
        }
        this.setOapiVersion(oapiVersion);
        this.setBuildTimeout(buildTimeout);
        this.setDisableApiGroupCheck(disableApiGroupCheck);
        if (openShiftUrl == null) {
            openShiftUrl = OpenShiftConfig.getDefaultOpenShiftUrl(this.getMasterUrl(), oapiVersion);
        }
        if (openShiftUrl == null || ((String)openShiftUrl).isEmpty()) {
            openShiftUrl = URLUtils.join((String[])new String[]{this.getMasterUrl(), "oapi", oapiVersion});
        }
        if (!((String)openShiftUrl).endsWith("/")) {
            openShiftUrl = (String)openShiftUrl + "/";
        }
        this.setOpenShiftUrl((String)openShiftUrl);
    }

    public static OpenShiftConfig wrap(Config config) {
        return config instanceof OpenShiftConfig ? (OpenShiftConfig)config : new OpenShiftConfig(config);
    }

    private static String getDefaultOapiVersion(String apiVersion) {
        return Utils.getSystemPropertyOrEnvVar((String)KUBERNETES_OAPI_VERSION_SYSTEM_PROPERTY, (String)apiVersion);
    }

    private static String getDefaultOpenShiftUrl(String masterUrl, String oapiVersion) {
        String openshiftUrl = Utils.getSystemPropertyOrEnvVar((String)OPENSHIFT_URL_SYSTEM_PROPERTY);
        if (openshiftUrl != null) {
            if (OpenShiftConfig.isRootURL(openshiftUrl)) {
                openshiftUrl = URLUtils.join((String[])new String[]{openshiftUrl, "oapi", oapiVersion});
            }
            return openshiftUrl;
        }
        return URLUtils.join((String[])new String[]{masterUrl, "oapi", oapiVersion});
    }

    private static boolean isRootURL(String url) {
        try {
            String path = new URL(url).getPath();
            return "".equals(path) || "/".equals(path);
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    @JsonIgnore
    public String getOapiVersion() {
        return this.getAdditionalProperties().getOrDefault(OAPI_VERSION, "v1");
    }

    public void setOapiVersion(String oapiVersion) {
        this.getAdditionalProperties().put(OAPI_VERSION, oapiVersion);
    }

    @JsonIgnore
    public String getOpenShiftUrl() {
        return (String)this.getAdditionalProperties().get(OPENSHIFT_URL);
    }

    public void setOpenShiftUrl(String openShiftUrl) {
        this.getAdditionalProperties().put(OPENSHIFT_URL, openShiftUrl);
    }

    public Long getBuildTimeout() {
        return this.getAdditionalProperties().getOrDefault(BUILD_TIMEOUT, DEFAULT_BUILD_TIMEOUT);
    }

    public void setBuildTimeout(long buildTimeout) {
        this.setBuildTimeout((Long)buildTimeout);
    }

    public void setBuildTimeout(Long buildTimeout) {
        if (buildTimeout == null) {
            this.getAdditionalProperties().remove(BUILD_TIMEOUT);
        } else {
            this.getAdditionalProperties().put(BUILD_TIMEOUT, buildTimeout);
        }
    }

    @JsonIgnore
    public boolean isDisableApiGroupCheck() {
        return Boolean.TRUE.equals(this.getAdditionalProperties().get(DISABLE_API_GROUP_CHECK));
    }

    public void setDisableApiGroupCheck(boolean disableApiGroupCheck) {
        this.setDisableApiGroupCheck((Boolean)disableApiGroupCheck);
    }

    public void setDisableApiGroupCheck(Boolean disableApiGroupCheck) {
        if (disableApiGroupCheck == null) {
            this.getAdditionalProperties().remove(DISABLE_API_GROUP_CHECK);
        } else {
            this.getAdditionalProperties().put(DISABLE_API_GROUP_CHECK, disableApiGroupCheck);
        }
    }

    public Readiness getReadiness() {
        return OpenShiftReadiness.getInstance();
    }
}

