/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.schema.generator.schema;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLParser;
import io.swagger.v3.core.util.DeserializationModule31;
import io.swagger.v3.core.util.Json31;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.SpecVersion;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.parser.OpenAPIV3Parser;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;

public class CrdParser {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final YAMLFactory yaml = new YAMLFactory((ObjectCodec)objectMapper);
    private static final Schema<Object> objectMeta;
    private static final Schema<Object> listMeta;

    public static OpenAPI crdToOpenApi(URI crdUri) throws IOException {
        YAMLParser parser = yaml.createParser(crdUri.toURL());
        List crds = objectMapper.readValues((JsonParser)parser, JsonNode.class).readAll().stream().filter(node -> node.path("apiVersion").asText().equals("apiextensions.k8s.io/v1")).filter(node -> node.path("kind").asText().equals("CustomResourceDefinition")).filter(node -> node.path("spec").path("versions").isArray()).collect(Collectors.toList());
        OpenAPI openAPI = new OpenAPI(SpecVersion.V31);
        openAPI.setInfo(new Info().title(""));
        openAPI.setPaths(new Paths());
        openAPI.setComponents(new Components());
        openAPI.getComponents().setSchemas(new HashMap());
        for (JsonNode crd : crds) {
            openAPI.getInfo().setTitle(openAPI.getInfo().getTitle() + crd.path("metadata").path("name").asText() + ";");
            Iterator it = crd.path("spec").path("versions").elements();
            while (it.hasNext()) {
                JsonNode crdVersion = (JsonNode)it.next();
                GroupVersionKind gvk = new GroupVersionKind();
                gvk.group = crd.path("spec").path("group").asText();
                gvk.version = crdVersion.path("name").asText();
                gvk.kind = crd.path("spec").path("names").path("kind").asText();
                gvk.plural = crd.path("spec").path("names").path("plural").asText();
                gvk.namespaced = crd.path("spec").path("scope").asText().equals("Namespaced");
                JsonNode openAPIV3Schema = crdVersion.path("schema").path("openAPIV3Schema");
                ObjectSchema schema = (ObjectSchema)objectMapper.convertValue((Object)openAPIV3Schema, ObjectSchema.class);
                if (schema.getProperties().get("metadata") == null) continue;
                schema.getProperties().put("metadata", objectMeta);
                openAPI.getPaths().addPathItem(gvk.getApiPath(), gvk.toPathItem());
                openAPI.getComponents().getSchemas().put(gvk.getRef(), schema);
                openAPI.getPaths().addPathItem(gvk.getListApiPath(), gvk.toListPathItem());
                openAPI.getComponents().getSchemas().put(gvk.getListRef(), CrdParser.listSchema(gvk));
            }
        }
        File tempOpenApi = Files.createTempFile("openapi", ".json", new FileAttribute[0]).toFile();
        Objects.requireNonNull(tempOpenApi.setReadable(true, true) ? Boolean.valueOf(true) : null, "Unable to set readable");
        Objects.requireNonNull(tempOpenApi.setWritable(true, true) ? Boolean.valueOf(true) : null, "Unable to set writeable");
        Objects.requireNonNull(tempOpenApi.setExecutable(true, true) ? Boolean.valueOf(true) : null, "Unable to set executable");
        tempOpenApi.deleteOnExit();
        Json31.pretty().writeValue(tempOpenApi, (Object)openAPI);
        return new OpenAPIV3Parser().read(tempOpenApi.getAbsolutePath());
    }

    private static Schema<Object> listSchema(GroupVersionKind gvk) {
        ObjectSchema ret = new ObjectSchema();
        ret.addProperty("apiVersion", (Schema)new StringSchema());
        ret.addProperty("items", (Schema)new ArraySchema().items(new Schema().$ref(gvk.getComponentRef())));
        ret.addProperty("kind", (Schema)new StringSchema());
        ret.addProperty("metadata", listMeta);
        return ret;
    }

    static {
        objectMapper.registerModule((Module)new DeserializationModule31());
        objectMeta = new Schema();
        objectMeta.$ref("#/components/schemas/io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta");
        listMeta = new Schema();
        listMeta.$ref("#/components/schemas/io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta");
    }

    private static class GroupVersionKind {
        String group;
        String version;
        String kind;
        String plural;
        boolean namespaced;

        private GroupVersionKind() {
        }

        private String getRef() {
            String[] groupParts = this.group.split("\\.");
            StringBuilder ret = new StringBuilder();
            for (int it = groupParts.length - 1; it >= 0; --it) {
                ret.append(groupParts[it]).append(".");
            }
            return ret.append(this.plural).append(".").append(this.version).append(".").append(this.kind).toString();
        }

        private String getListRef() {
            return this.getRef() + "List";
        }

        private String getComponentRef() {
            return "#/components/schemas/" + this.getRef();
        }

        private String getListComponentRef() {
            return this.getComponentRef() + "List";
        }

        private String getApiPath() {
            StringBuilder apiPath = new StringBuilder().append("/apis/").append(this.group).append("/").append(this.version);
            if (this.namespaced) {
                apiPath.append("/namespaces/{namespace}");
            }
            apiPath.append("/").append(this.plural);
            apiPath.append("/{name}");
            return apiPath.toString();
        }

        private PathItem toPathItem() {
            PathItem ret = new PathItem();
            ret.operation(PathItem.HttpMethod.GET, new Operation());
            if (this.namespaced) {
                ret.getGet().addParametersItem(new Parameter().name("namespace").in("path").required(Boolean.valueOf(true)));
            }
            Content content = new Content().addMediaType("application/json", new MediaType().schema(new Schema().$ref(this.getListComponentRef())));
            ret.getGet().responses(new ApiResponses().addApiResponse("200", new ApiResponse().description("OK").content(content)));
            ret.getGet().extensions(new HashMap());
            ret.getGet().getExtensions().put("x-kubernetes-group-version-kind", this);
            return ret;
        }

        private String getListApiPath() {
            StringBuilder apiPath = new StringBuilder().append("/apis/").append(this.group).append("/").append(this.version);
            if (this.namespaced) {
                apiPath.append("/namespaces/{namespace}");
            }
            apiPath.append("/").append(this.plural);
            return apiPath.toString();
        }

        private PathItem toListPathItem() {
            PathItem ret = new PathItem();
            ret.operation(PathItem.HttpMethod.GET, new Operation());
            if (this.namespaced) {
                ret.getGet().addParametersItem(new Parameter().name("namespace").in("path").required(Boolean.valueOf(true)));
            }
            ret.getGet().addParametersItem(new Parameter().name("name").in("path").required(Boolean.valueOf(true)));
            Content content = new Content().addMediaType("application/json", new MediaType().schema(new Schema().$ref(this.getComponentRef())));
            ret.getGet().responses(new ApiResponses().addApiResponse("200", new ApiResponse().description("OK").content(content)));
            ret.getGet().extensions(new HashMap());
            ret.getGet().getExtensions().put("x-kubernetes-group-version-kind", this);
            return ret;
        }

        @Generated
        public String getGroup() {
            return this.group;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public String getKind() {
            return this.kind;
        }

        @Generated
        public String getPlural() {
            return this.plural;
        }

        @Generated
        public boolean isNamespaced() {
            return this.namespaced;
        }
    }
}

