/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.letschat;

import io.fabric8.letschat.LetsChatApi;
import io.fabric8.letschat.RoomDTO;
import io.fabric8.letschat.Rooms;
import io.fabric8.letschat.TokenDTO;
import io.fabric8.letschat.UserDTO;
import io.fabric8.utils.Lists;
import io.fabric8.utils.Strings;
import io.fabric8.utils.cxf.WebClients;
import java.util.List;
import java.util.concurrent.Callable;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LetsChatClientSupport {
    private static final transient Logger LOG = LoggerFactory.getLogger(LetsChatClientSupport.class);
    protected final String address;
    protected final String username;
    protected final String password;
    protected String authToken;
    private LetsChatApi api;
    private boolean createToken = false;

    public LetsChatClientSupport(String address, String username, String password, String authToken) {
        this.address = address;
        this.username = username;
        this.password = password;
        this.authToken = authToken;
    }

    public RoomDTO getOrCreateRoom(String idOrSlug) {
        RoomDTO room = this.getRoom(idOrSlug);
        if (room == null) {
            room = new RoomDTO();
            room.setSlug(idOrSlug);
            room.setName(idOrSlug);
            room.setDescription("Description of room " + idOrSlug);
            Rooms.setOwner(room, this.getAccount());
            return this.createRoom(room);
        }
        return room;
    }

    @POST
    @Path(value="rooms")
    public RoomDTO createRoom(RoomDTO dto) {
        return this.getApi().createRoom(dto);
    }

    @GET
    @Path(value="rooms/{id}")
    public RoomDTO getRoom(final String idOrSlug) {
        return (RoomDTO)WebClients.handle404ByReturningNull((Callable)new Callable<RoomDTO>(){

            @Override
            public RoomDTO call() throws Exception {
                return LetsChatClientSupport.this.getApi().getRoom(idOrSlug);
            }
        });
    }

    @GET
    @Path(value="users/{userId}")
    public UserDTO getUser(final String id) {
        return (UserDTO)WebClients.handle404ByReturningNull((Callable)new Callable<UserDTO>(){

            @Override
            public UserDTO call() throws Exception {
                return LetsChatClientSupport.this.getApi().getUser(id);
            }
        });
    }

    @GET
    @Path(value="account")
    public UserDTO getAccount() {
        return (UserDTO)WebClients.handle404ByReturningNull((Callable)new Callable<UserDTO>(){

            @Override
            public UserDTO call() throws Exception {
                return LetsChatClientSupport.this.getApi().getAccount();
            }
        });
    }

    @GET
    @Path(value="rooms")
    public List<RoomDTO> getRooms() {
        List answer = (List)WebClients.handle404ByReturningNull((Callable)new Callable<List<RoomDTO>>(){

            @Override
            public List<RoomDTO> call() throws Exception {
                return LetsChatClientSupport.this.getApi().getRooms();
            }
        });
        return Lists.notNullList((List)answer);
    }

    @GET
    @Path(value="rooms/{id}/users")
    public List<UserDTO> getRoomUsers(final String idOrSlug) {
        List answer = (List)WebClients.handle404ByReturningNull((Callable)new Callable<List<UserDTO>>(){

            @Override
            public List<UserDTO> call() throws Exception {
                return LetsChatClientSupport.this.getApi().getRoomUsers(idOrSlug);
            }
        });
        return Lists.notNullList((List)answer);
    }

    @PUT
    @Path(value="rooms/{id}")
    public void updateRoom(String idOrSlug, RoomDTO room) {
        this.getApi().updateRoom(idOrSlug, room);
    }

    @DELETE
    @Path(value="rooms/{id}")
    public void deleteRoom(String idOrSlug) {
        this.getApi().deleteRoom(idOrSlug);
    }

    public String getAddress() {
        return this.address;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public boolean isValid() {
        return Strings.isNotBlank((String)this.authToken);
    }

    protected abstract <T> T createWebClient(Class<T> var1);

    protected LetsChatApi getApi() {
        if (this.api == null) {
            this.api = this.createWebClient(LetsChatApi.class);
            if (this.createToken) {
                if (Strings.isNullOrBlank((String)this.authToken)) {
                    this.generateToken(this.api);
                }
            } else if (!(Strings.isNotBlank((String)this.username) && Strings.isNotBlank((String)this.password) || !Strings.isNullOrBlank((String)this.authToken))) {
                LOG.info("username: " + this.username + " password: " + this.password);
                throw new IllegalArgumentException("No token available for letschat so cannot login. Try setting the $LETSCHAT_HUBOT_TOKEN environment variable?");
            }
        }
        return this.api;
    }

    protected void generateToken(LetsChatApi api) {
        try {
            api.revokeToken();
        }
        catch (Exception e) {
            LOG.warn("Ignored error revoking: " + e, (Throwable)e);
        }
        TokenDTO tokenDTO = api.generateToken();
        if (tokenDTO != null) {
            this.authToken = tokenDTO.getToken();
        }
    }
}

