package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TLSRouteListBuilder extends TLSRouteListFluentImpl<TLSRouteListBuilder> implements VisitableBuilder<TLSRouteList,TLSRouteListBuilder>{
  public TLSRouteListBuilder() {
    this(false);
  }
  public TLSRouteListBuilder(Boolean validationEnabled) {
    this(new TLSRouteList(), validationEnabled);
  }
  public TLSRouteListBuilder(TLSRouteListFluent<?> fluent) {
    this(fluent, false);
  }
  public TLSRouteListBuilder(TLSRouteListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TLSRouteList(), validationEnabled);
  }
  public TLSRouteListBuilder(TLSRouteListFluent<?> fluent,TLSRouteList instance) {
    this(fluent, instance, false);
  }
  public TLSRouteListBuilder(TLSRouteListFluent<?> fluent,TLSRouteList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public TLSRouteListBuilder(TLSRouteList instance) {
    this(instance,false);
  }
  public TLSRouteListBuilder(TLSRouteList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  TLSRouteListFluent<?> fluent;
  Boolean validationEnabled;
  public TLSRouteList build() {
    TLSRouteList buildable = new TLSRouteList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}