package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ReferencePolicyListBuilder extends ReferencePolicyListFluentImpl<ReferencePolicyListBuilder> implements VisitableBuilder<ReferencePolicyList,ReferencePolicyListBuilder>{
  public ReferencePolicyListBuilder() {
    this(false);
  }
  public ReferencePolicyListBuilder(Boolean validationEnabled) {
    this(new ReferencePolicyList(), validationEnabled);
  }
  public ReferencePolicyListBuilder(ReferencePolicyListFluent<?> fluent) {
    this(fluent, false);
  }
  public ReferencePolicyListBuilder(ReferencePolicyListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ReferencePolicyList(), validationEnabled);
  }
  public ReferencePolicyListBuilder(ReferencePolicyListFluent<?> fluent,ReferencePolicyList instance) {
    this(fluent, instance, false);
  }
  public ReferencePolicyListBuilder(ReferencePolicyListFluent<?> fluent,ReferencePolicyList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ReferencePolicyListBuilder(ReferencePolicyList instance) {
    this(instance,false);
  }
  public ReferencePolicyListBuilder(ReferencePolicyList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ReferencePolicyListFluent<?> fluent;
  Boolean validationEnabled;
  public ReferencePolicyList build() {
    ReferencePolicyList buildable = new ReferencePolicyList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}