/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples.kubectl.equivalents;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.ExecListener;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PodExecEquivalent {
    private static final Logger logger = LoggerFactory.getLogger(PodExecEquivalent.class);
    private static final CountDownLatch execLatch = new CountDownLatch(1);

    public static void main(String[] args) {
        try (KubernetesClient k8s = new KubernetesClientBuilder().build();){
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayOutputStream error = new ByteArrayOutputStream();
            ExecWatch execWatch = ((PodResource)((NonNamespaceOperation)k8s.pods().inNamespace("default")).withName("my-pod")).writingOutput((OutputStream)out).writingError((OutputStream)error).usingListener((ExecListener)new MyPodExecListener()).exec(new String[]{"ls", "/"});
            boolean latchTerminationStatus = execLatch.await(5L, TimeUnit.SECONDS);
            if (!latchTerminationStatus) {
                logger.warn("Latch could not terminate within specified time");
            }
            logger.info("Exec Output: {} ", (Object)out);
            execWatch.close();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            logger.warn("Interrupted while waiting for the exec: {}", (Object)ie.getMessage());
        }
    }

    private static class MyPodExecListener
    implements ExecListener {
        private MyPodExecListener() {
        }

        public void onOpen() {
            logger.info("Shell was opened");
        }

        public void onFailure(Throwable t, ExecListener.Response failureResponse) {
            logger.info("Some error encountered");
            execLatch.countDown();
        }

        public void onClose(int i, String s) {
            logger.info("Shell Closing");
            execLatch.countDown();
        }
    }
}

