/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicy;
import io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicyBuilder;
import io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicyFluent;
import io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.io.InputStream;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PodSecurityPolicyExample {
    private static final Logger logger = LoggerFactory.getLogger(PodSecurityPolicyExample.class);

    public static void main(String[] args) {
        try (KubernetesClient client = new KubernetesClientBuilder().build();){
            String localYamlToCreate = "/PodSecurityPolicy.yml";
            logger.info("Creating PodSecurityPolicy from Yaml file: {}", (Object)"/PodSecurityPolicy.yml");
            try (InputStream localYamlStream = PodSecurityPolicyExample.class.getResourceAsStream("/PodSecurityPolicy.yml");){
                PodSecurityPolicy podSecurityPolicy = (PodSecurityPolicy)((Resource)client.policy().v1beta1().podSecurityPolicies().load(localYamlStream)).item();
                ((Resource)client.policy().v1beta1().podSecurityPolicies().withName(podSecurityPolicy.getMetadata().getName())).delete();
                ((Resource)client.policy().v1beta1().podSecurityPolicies().withName(podSecurityPolicy.getMetadata().getName())).waitUntilCondition(Objects::isNull, 5L, TimeUnit.SECONDS);
                ((Resource)client.policy().v1beta1().podSecurityPolicies().resource((Object)podSecurityPolicy)).create();
                logger.info("PodSecurityPolicy created with Name : {}", (Object)podSecurityPolicy.getMetadata().getName());
            }
            logger.info("Starting creating PodSecurityPolicy programmatically");
            String podSecurityPolicyName = "example2";
            ((Resource)client.policy().v1beta1().podSecurityPolicies().withName("example2")).delete();
            ((Resource)client.policy().v1beta1().podSecurityPolicies().withName("example2")).waitUntilCondition(Objects::isNull, 5L, TimeUnit.SECONDS);
            PodSecurityPolicy programmaticPodSecurityPolicy = ((PodSecurityPolicyBuilder)((PodSecurityPolicyFluent.SpecNested)((PodSecurityPolicySpecFluent.SupplementalGroupsNested)((PodSecurityPolicyFluent.SpecNested)((PodSecurityPolicySpecFluent.SeLinuxNested)((PodSecurityPolicyFluent.SpecNested)((PodSecurityPolicySpecFluent.FsGroupNested)((PodSecurityPolicyFluent.SpecNested)((PodSecurityPolicySpecFluent.RunAsUserNested)((PodSecurityPolicyFluent.SpecNested)((PodSecurityPolicyBuilder)((PodSecurityPolicyFluent.MetadataNested)new PodSecurityPolicyBuilder().withNewMetadata().withName("example2")).endMetadata()).withNewSpec().withPrivileged(Boolean.valueOf(false))).withNewRunAsUser().withRule("RunAsAny")).endRunAsUser()).withNewFsGroup().withRule("RunAsAny")).endFsGroup()).withNewSeLinux().withRule("RunAsAny")).endSeLinux()).withNewSupplementalGroups().withRule("RunAsAny")).endSupplementalGroups()).endSpec()).build();
            ((Resource)client.policy().v1beta1().podSecurityPolicies().resource((Object)programmaticPodSecurityPolicy)).create();
            logger.info("PodSecurityPolicy created with Name: {}", (Object)programmaticPodSecurityPolicy.getMetadata().getName());
        }
        catch (KubernetesClientException clientException) {
            logger.error("Problem encountered with Kubernetes client!!", (Throwable)clientException);
        }
        catch (Exception e) {
            logger.error("Exception encountered : {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

