/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples.kubectl.equivalents;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PodSortByCreationTimestamp {
    private static final Logger logger = LoggerFactory.getLogger(PodSortByCreationTimestamp.class);

    public static void main(String[] args) {
        try (KubernetesClient k8s = new KubernetesClientBuilder().build();){
            List podList = ((PodList)((NonNamespaceOperation)k8s.pods().inNamespace("default")).list()).getItems();
            podList.sort((o1, o2) -> {
                long o1Timestamp = Instant.parse(o1.getMetadata().getCreationTimestamp()).getEpochSecond();
                long o2Timestamp = Instant.parse(o2.getMetadata().getCreationTimestamp()).getEpochSecond();
                return (int)(o2Timestamp - o1Timestamp);
            });
            for (Pod pod : podList) {
                logger.info("{} : {} minutes old", (Object)pod.getMetadata().getName(), (Object)Duration.between(Instant.now(), Instant.parse(pod.getMetadata().getCreationTimestamp())).toMinutes());
            }
        }
    }
}

