/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.utils.Utils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadMultipleDocumentsFromFileExample {
    private static final Logger logger = LoggerFactory.getLogger(LoadMultipleDocumentsFromFileExample.class);

    public static void main(String[] args) {
        ConfigBuilder configBuilder = new ConfigBuilder();
        if (args.length > 0) {
            configBuilder.withMasterUrl(args[0]);
        }
        try (KubernetesClient client = new KubernetesClientBuilder().withConfig(configBuilder.build()).build();){
            List list = client.load(LoadMultipleDocumentsFromFileExample.class.getResourceAsStream("/multiple-document-template.yml")).items();
            logger.info("Found in file: {} items.", (Object)list.size());
            for (HasMetadata meta : list) {
                logger.info(LoadMultipleDocumentsFromFileExample.display(meta));
            }
            list = client.load(LoadMultipleDocumentsFromFileExample.class.getResourceAsStream("/multiple-document-template.yml")).items();
            KubernetesListBuilder kubernetesListBuilder = new KubernetesListBuilder();
            kubernetesListBuilder.addAllToItems((Collection)list);
            kubernetesListBuilder.accept(new Visitor[]{new Visitor<ObjectMetaBuilder>(){

                public void visit(ObjectMetaBuilder item) {
                    item.addToLabels("visitorkey", "visitorvalue");
                }
            }});
            logger.info("Visited: {} items.", (Object)list.size());
            for (HasMetadata meta : list) {
                logger.info(LoadMultipleDocumentsFromFileExample.display(meta));
            }
        }
    }

    private static String display(HasMetadata item) {
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        if (Utils.isNotNullOrEmpty((String)item.getKind())) {
            sb.append(" Kind:").append(item.getKind());
        }
        if (Utils.isNotNullOrEmpty((String)item.getMetadata().getName())) {
            sb.append(" Name:").append(item.getMetadata().getName());
        }
        if (item.getMetadata().getLabels() != null && !item.getMetadata().getLabels().isEmpty()) {
            sb.append(" Lables: [ ");
            for (Map.Entry entry : item.getMetadata().getLabels().entrySet()) {
                sb.append((String)entry.getKey()).append(":").append((String)entry.getValue()).append(" ");
            }
            sb.append("]");
        }
        sb.append(" ]");
        return sb.toString();
    }
}

