/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples.kubectl.equivalents;

import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortForwardEquivalent {
    private static final Logger logger = LoggerFactory.getLogger(PortForwardEquivalent.class);

    public static void main(String[] args) {
        try (DefaultKubernetesClient k8s = new DefaultKubernetesClient();){
            CountDownLatch countDownLatch = new CountDownLatch(1);
            ((PodResource)((NonNamespaceOperation)k8s.pods().inNamespace("default")).withName("my-pod")).portForward(80, 8080);
            logger.info("Port forward open for 10 seconds");
            boolean latchTerminationStatus = countDownLatch.await(10L, TimeUnit.SECONDS);
            if (!latchTerminationStatus) {
                logger.debug("latch terminated before it's count reaching zero");
            }
            logger.info("Closing port forward");
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            logger.warn("Interrupted while waiting for the port forward to be ready: {}", (Object)interruptedException.getMessage());
        }
    }
}

