/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.EndpointPort;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.EndpointSubsetFluent;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsBuilder;
import io.fabric8.kubernetes.api.model.EndpointsFluent;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointsExample {
    private static final Logger logger = LoggerFactory.getLogger(EndpointsExample.class);
    private static final String NAMESPACE = "endpoints-example";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try (DefaultKubernetesClient client = new DefaultKubernetesClient();){
            Namespace ns = ((NamespaceBuilder)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName(NAMESPACE)).addToLabels("this", "rocks")).endMetadata()).build();
            logger.info("Created namespace: {}", client.namespaces().createOrReplace((Object[])new Namespace[]{ns}));
            try {
                logger.info("Namespace: {}", (Object)ns);
                Deployment deployment = (Deployment)((RollableScalableResource)((NonNamespaceOperation)client.apps().deployments().inNamespace(NAMESPACE)).load(EndpointsExample.class.getResourceAsStream("/endpoints-deployment.yml"))).get();
                logger.info("Deployment created");
                ((NonNamespaceOperation)client.apps().deployments().inNamespace(NAMESPACE)).create((Object)deployment);
                Service service = (Service)((ServiceResource)((NonNamespaceOperation)client.services().inNamespace(NAMESPACE)).load(EndpointsExample.class.getResourceAsStream("/endpoints-service.yml"))).get();
                logger.info("Service created");
                ((NonNamespaceOperation)client.services().inNamespace(NAMESPACE)).create((Object)service);
                Endpoints endpoints = ((EndpointsBuilder)((EndpointsFluent.SubsetsNested)((EndpointSubsetFluent.PortsNested)((EndpointSubsetFluent.PortsNested)((EndpointsFluent.SubsetsNested)((EndpointSubsetFluent.AddressesNested)((EndpointsBuilder)((EndpointsBuilder)((EndpointsFluent.MetadataNested)((EndpointsFluent.MetadataNested)new EndpointsBuilder().withNewMetadata().withName("external-web")).withNamespace(NAMESPACE)).endMetadata()).withSubsets(new EndpointSubset[0])).addNewSubset().addNewAddress().withIp("10.10.50.53")).endAddress()).addNewPort().withPort(Integer.valueOf(80))).withName("apache")).endPort()).endSubset()).build();
                logger.info("Endpoint created");
                ((NonNamespaceOperation)client.endpoints().inNamespace(NAMESPACE)).create((Object)endpoints);
                logger.info("Endpoint url");
                endpoints = (Endpoints)((Resource)((NonNamespaceOperation)client.endpoints().inNamespace(NAMESPACE)).withName("external-web")).get();
                logger.info("Endpoint Port {}", (Object)((EndpointPort)((EndpointSubset)endpoints.getSubsets().get(0)).getPorts().get(0)).getName());
            }
            catch (Exception e) {
                logger.error("Exception occurred: {}", (Object)e.getMessage(), (Object)e);
            }
            finally {
                ((Resource)client.namespaces().withName(NAMESPACE)).delete();
            }
        }
    }
}

