/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawCustomResourceExample {
    private static final Logger logger = LoggerFactory.getLogger(RawCustomResourceExample.class);

    public static void main(String[] args) throws Exception {
        ConfigBuilder configBuilder = new ConfigBuilder();
        configBuilder.withWatchReconnectInterval(500);
        configBuilder.withWatchReconnectLimit(5);
        try (DefaultKubernetesClient client = new DefaultKubernetesClient(configBuilder.build());){
            String namespace = "default";
            CustomResourceDefinition prometheousRuleCrd = (CustomResourceDefinition)((Resource)client.apiextensions().v1beta1().customResourceDefinitions().load(RawCustomResourceExample.class.getResourceAsStream("/prometheous-rule-crd.yml"))).get();
            client.apiextensions().v1beta1().customResourceDefinitions().createOrReplace((Object[])new CustomResourceDefinition[]{prometheousRuleCrd});
            logger.info("Successfully created Prometheous custom resource definition");
            CustomResourceDefinitionContext crdContext = CustomResourceDefinitionContext.fromCrd((CustomResourceDefinition)prometheousRuleCrd);
            client.customResource(crdContext).createOrReplace(namespace, RawCustomResourceExample.class.getResourceAsStream("/prometheous-rule-cr.yml"));
            logger.info("Created Custom Resource successfully too");
            Map list = client.customResource(crdContext).list(namespace);
            List items = (List)list.get("items");
            logger.info("Custom Resources :- ");
            for (Map customResource : items) {
                Map metadata = (Map)customResource.get("metadata");
                String name = metadata.get("name").toString();
                logger.info(name);
            }
            logger.info("Watching custom resources now");
            final CountDownLatch closeLatch = new CountDownLatch(1);
            client.customResource(crdContext).watch(namespace, (Watcher)new Watcher<String>(){

                public void eventReceived(Watcher.Action action, String resource) {
                    logger.info("{}: {}", (Object)action, (Object)resource);
                }

                public void onClose(WatcherException e) {
                    logger.debug("Watcher onClose");
                    closeLatch.countDown();
                    if (e != null) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            });
            closeLatch.await(10L, TimeUnit.MINUTES);
            logger.info("Deleting custom resources...");
            client.customResource(crdContext).delete(namespace, "prometheus-example-rules");
            ((Resource)client.apiextensions().v1beta1().customResourceDefinitions().withName(prometheousRuleCrd.getMetadata().getName())).delete();
        }
        catch (KubernetesClientException e) {
            logger.error("Could not create resource: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

